// Still trying to get to  that strange synchronization issue...
// So this is a simple player applicaton excercising input(s) and a single output channel.
// Those funky thread sync issues should appear here, too...

#include "basics.hxx"
#include "param_init.hxx"

#include "inchannel.hxx"
#include "outchannel.hxx"
#include "coms/client_api.hxx"

#include <string>
#include <vector>
using std::string;
using std::vector;

#include "shortcuts.hxx"
#include "debug.hxx"

off_t play(const string file);

// We still have that hack. See input_worker and mixer.
real_mutex playlock;

int main(int argc, char **argv)
{
	if(param.parse(argc, argv))
	{
		if(param.as_bool("help"))
		{
			param.help();
			return 0;
		}
		if(argc != 1)
		{
			SERROR("I need exactly one file as argument.");
			return -1;
		}
		off_t count = play(argv[0]);
		fprintf(stderr, "played %"OFF_P" samples\n", (off_p)count);
	}
	else
	{
		SERROR("Meh, parsing did not work.");
		return -1;
	}

	return 0;
}

void print_errors(errorchain &erc)
{
	vector<string*> lines;
	erc.stringify(lines);
	FOR_VECTOR(string*, lines, l)
	{
		fprintf(stderr, "ERR: %s\n", (*l)->c_str());
		delete *l;
	}
}

off_t play(const string file)
{
	off_t count = 0;
	semaphore playsem;
	audio_format format;
	format.channels = param.as_uint("channels");
	format.rate = param.as_ulint("audio_rate");
	size_t bufsize = param.as_size("buffer");
	dmd::actionlist actions; // A stub... 
	comm_data sinker;
	dmd::inchannel devil(42, "some channel", &playsem, format, bufsize, actions, sinker);
	dmd::outchannel abyss(2, "the sink", playsem, actions);
	if(devil.status != dmd::channel::DEAD && abyss.status != dmd::channel::DEAD)
	{
		comm_data com;
		action act(dmd::api::client_world);
		act.comdat = &com;

		devil.bind(&abyss);
		abyss.bind(&devil);
		fprintf(stderr, "Channels healthy, loading...\n");

		act.parse(string("load 0 ") + file);
		devil.handle_action(&act, &com);
		com.waitress->wait();
		if(!com.errors.empty())
		{
			print_errors(com.errors);
			return 0;
		}
		fprintf(stderr, "Load done.\n");
		devil.sync_state();

		act.parse("outload 0 default doesnotmatter");
		abyss.handle_action(&act);
		com.waitress->wait();
		if(!com.errors.empty())
		{
			print_errors(com.errors);
			return 0;
		}
		abyss.sync_state();
		fprintf(stderr, "Output load done.\n");

		abyss.status = dmd::channel::PLAYING;

		// Decode, mix to output ... play...
		do
		{
			// Decode a bit.
			devil.play(bufsize);
			playsem.wait();
			devil.sync_state();
			fprintf(stderr, "decoded at %"OFF_P" (%zu/%zu)\n", devil.state.position, devil.buffer.fill, bufsize);
			// Errors will manifest in ill-filled buffer.
			count += devil.inbuffer.fill;

			// Output buffer will be filled.
			abyss.play();
			playsem.wait();
			fprintf(stderr, "issued playback\n");
			// We are done when there was no more data.
		} while (devil.buffer.fill == bufsize);
		devil.sync_state();
		fprintf(stderr, "finished at %"OFF_P" of %"OFF_P"\n", devil.state.position, devil.state.length);
		sleep(1); // Give it some time to flush output buffers.
	}
	return count;
}

