// Basic testing of the LADSPA module loader... Perhaps also some basic filtering, let's see.

#include "basics.hxx"
#include "audio/effect/ladspa.hxx"
#include "shortcuts.hxx"
#include "single.hxx"

#include "debug.hxx"

int main(int argc, char **argv)
{
	dmd::effect::ladspa lad;
	std::vector<std::string*> libs;

	dmd::effect::ladspa_init();

	lad.list_libs(libs);
	printf("Available libraries (%zu):\n", libs.size());
	FOR_VECTOR(std::string*, libs, lib)
	{
		std::vector<std::string*> plugins;
		lad.list_plugins(**lib, plugins);
		printf("%s (%zu plugins)\n", (*lib)->c_str(), plugins.size());
		FOR_VECTOR(std::string*, plugins, plug)
		printf("\t%s\n", (*plug)->c_str());

		delete *lib;
	}

	return 0;
}
