// Trying to debug that trouble with libmpg123... 
// This code decodes a given input file via a full input_device instance (including the background worker thread and optional FIFO).
// Also serves as minimal example of code that uses DerMixD input devices to decode things...

#include "basics.hxx"
#include "param_init.hxx"

#include "inchannel.hxx"
#include "coms/client_api.hxx"

#include <string>
#include <vector>
using std::string;
using std::vector;

#include "shortcuts.hxx"
#include "debug.hxx"

off_t slurp(const string file, FILE* output);

// We still have that hack. See input_worker and mixer.
real_mutex playlock;

int main(int argc, char **argv)
{
	if(param.parse(argc, argv))
	{
		if(param.as_bool("help"))
		{
			param.help();
			return 0;
		}
		if(argc != 1)
		{
			SERROR("I need exactly one file as argument.");
			return -1;
		}
		off_t count = slurp(argv[0], stdout);
		fprintf(stderr, "slurped %"OFF_P"\n", (off_p)count);
	}
	else
	{
		SERROR("Meh, parsing did not work.");
		return -1;
	}

	return 0;
}

void print_errors(errorchain &erc)
{
	vector<string*> lines;
	erc.stringify(lines);
	FOR_VECTOR(string*, lines, l)
	{
		fprintf(stderr, "ERR: %s\n", (*l)->c_str());
		delete *l;
	}
}

off_t slurp(const string file, FILE* output)
{
	off_t count = 0;
	semaphore playsem;
	audio_format format;
	format.channels = 2;
	format.rate = 1000; // Does not matter.
	dmd::actionlist actions;
	comm_data sinker;
	dmd::inchannel devil(42, "some channel", &playsem, format, 1000, actions, sinker);
	if(devil.status != dmd::channel::DEAD)
	{
		comm_data com;
		fprintf(stderr, "Input device is healthy, loading...\n");
		action *act = dmd::api::one_time_act("load 0 " + file, &com);
		if(act != NULL)
		{
			devil.handle_action(act);
			com.waitress->wait();
			fprintf(stderr, "Load done.\n");
		}
		if(!com.errors.empty())
		{
			print_errors(com.errors);
			return 0;
		}

		size_t bufsize = param.as_size("buffer");
		do
		{
			// Decode a bit.
			devil.play(bufsize);
			playsem.wait();
			devil.sync_state();
			fprintf(stderr, "decoded at %"OFF_P" (%zu/%zu)\n", devil.state.position, devil.inbuffer.fill, bufsize);
			// Errors will manifest in ill-filled buffer.

			// Dump the decoded data to the output.
			fwrite(devil.inbuffer.ptr, devil.inbuffer.blocksize(), devil.inbuffer.fill, output);
			count += devil.inbuffer.fill;
			// We are done when there was no more data.
		} while (devil.inbuffer.fill == bufsize);
		devil.sync_state();
		fprintf(stderr, "finished at %"OFF_P" of %"OFF_P"\n", devil.state.position, devil.state.length);
	}
	return count;
}

