// Trying to debug that trouble with libmpg123... 
// This code decodes a given input file via a full input_device instance (including the background worker thread and optional FIFO).
// Also serves as minimal example of code that uses DerMixD input devices to decode things...

#include "basics.hxx"
#include "param_init.hxx"

#include "inchannel.hxx"
#include "coms/client_api.hxx"

#include <string>
#include <vector>
using std::string;
using std::vector;

#include "shortcuts.hxx"
#include "debug.hxx"

int slurp();

int main(int argc, char **argv)
{
	param.define("test", "channels", "2", "number of input channels to create and read from in parallel");
	param.define("test", "buffers", "1000", "How many buffer fills of data to read from the channels.");
	if(param.parse(argc, argv))
	{
		if(param.as_bool("help"))
		{
			param.help();
			return 0;
		}
		return slurp();
	}
	else
	{
		SERROR("Meh, parsing did not work.");
		return -1;
	}

	return 0;
}

void print_errors(errorchain &erc)
{
	vector<string*> lines;
	erc.stringify(lines);
	FOR_VECTOR(string*, lines, l)
	{
		fprintf(stderr, "ERR: %s\n", (*l)->c_str());
		delete *l;
	}
}

int slurp()
{
	semaphore playsem;
	audio_format format;
	comm_data sinker;
	format.channels = param.as_uint("main", "channels");
	format.rate = param.as_ulint("main", "audio_rate");
	vector<dmd::inchannel*> channels;
	size_t chans = param.as_size("test", "channels");
	size_t bufsize = param.as_size("main", "buffer");
	comm_data com;
	dmd::actionlist actions;
	for(size_t i=0; i<chans; ++i)
	{
		channels.push_back(new dmd::inchannel(i, "test channel", &playsem, format, bufsize, actions, sinker));
		if(channels.back()->status == dmd::channel::NODEV)
		{
			action *act = dmd::api::one_time_act("load 0 sine://440@44100",  &com);
			if(act != NULL)
			{
				channels.back()->handle_action(act);
				com.waitress->wait();
			}
			if(!com.errors.empty())
			{
				print_errors(com.errors);
				return -1;
			}
		}
		else{ MERROR("Channel %zu is not well.", i); return -2; }
	}

	unsigned long buffers = param.as_ulint("test", "buffers");
	fprintf(stderr, "Starting playback of %li buffers on %zu channels...\n", buffers, chans);
	for(unsigned long bufc = 0; bufc < buffers; ++bufc)
	{
		for(size_t i=0; i<chans; ++i)
		channels[i]->play(bufsize);

		for(size_t i=0; i<chans; ++i)
		playsem.wait();
	}
	fprintf(stderr, "Done with play.\n");

	for(size_t i=0; i<chans; ++i)
	{
		delete channels[i];
	}

	return 0;
}

