/*
	errorchain: Test for basic functionality of the error chain.

	part of DerMixD
	(c)2009 Thomas Orgis, licensed under GPLv2

	This just pushes some fake errors to the chain, also messing a bit with errno.
	Then we see the printout of that chain.
*/

#include "basics.hxx"

#include <iostream>
#include <cerrno>
#include <string>
#include <vector>

#include "errorchain.hxx"


#include "debug.hxx"
#include "shortcuts.hxx"

using namespace std;

int main(int argc, char **argv)
{
	errorchain ec;

	errno = 11;
	ec.push(new error("groundlevel", 2, "This is a basic screwup (I set errno to 11)"));
	errno = 0;
	ec.push(new error("lowlevel", 77, "Again issues, with a directly forced errno.", 10));
	ec.push(new error("middle", 12, "This is the usual followup."));

	if(ec.count() != 3)
	{
		SERROR("Bad error count!");
		return -1;
	}

	vector<string*> lines;
	ec.stringify(lines);

	cout << "The error chain:\n";
	FOR_VECTOR(string*, lines, l) cout << **l << "\n";

	cout << "^^ That was the topmost (followup) error.\n";

	ec.clear();
	if(ec.count() != 0)
	{
		SERROR("Clearing did not work!");
		return -2;
	}

	return 0;
}
