// Simple test of daemonization.
// Just daemonize and quit... the daemon after sleeping some time.

#include "basics.hxx"
#include "daemon.hxx"

#include <sys/types.h>
#include <unistd.h>

#include <stdio.h>

#include "debug.hxx"

int main(int argc, char **argv)
{
	if(argc < 3)
	{
		SERROR("Please specify output files for daemon messages!\n");
		return 1;
	}
	printf("Starting up with PID %i...\n", (int)getpid());
	if(daemonize(argv[1], argv[2]))
	{
		printf("(STDOUT) I am the daemon with PID %i!\n", (int)getpid());
		fprintf(stderr, "(STDERR) This is the daemon's standard error output.\n");
		printf("(STDOUT) Second line on stdout... goodbye.\n");
		return 0;
	}
	else
	{
		SERROR("Daemonization failed!");
		return 2;
	}
}
