// Use the file browsing code for some kind of interactive shell.
// Commands: pwd, cd, ls
// If you give command line arguments, they get a listing and adjustment.
// This is also a test of textread and comparse...
#include "basics.hxx"
#include "browse.hxx"

#include <vector>
using std::vector;
#include <string>
using std::string;

#include "textread.hxx"
#include "comparse.hxx"
#include "tstring.hxx"

#include "debug.hxx"
#include "shortcuts.hxx"

int main(int argc, char** argv)
{
	dmd::browser bro;

	if(argc > 1)
	{
		vector<string> quest;
		vector<string*> listing;
		for(int i=1; i<argc; ++i)
		quest.push_back(string(argv[i]));

		bro.browse(quest, listing);
		FOR_VECTOR(string, quest, q)
		{
			printf("adjusting %s\n", q->c_str());
			bro.adjust_path(*q);
			printf("to        %s\n", q->c_str());
		}
		printf("\nThe listing:\n");
		FOR_VECTOR(string*, listing, l)
		printf("%s\n", (*l)->c_str());
	}
	else
	{
		char *line = NULL;
		size_t size = 0;
		size_t len;
		fprintf(stderr, "> ");
		while((len = dmd::getline(stdin, line, size)) > 0)
		{
			dmd::chomp(line, len);
			string com;
			if(commando(line, com))
			{
				lowercase(com);
				vector<string> tokens;
				if(com == "pwd")
				{
					string wd;
					if(bro.pwd(wd)) printf("Current dir: %s\n", wd.c_str());
					else printf("Error getting current directory!\n");
				}
				else if(com == "ls")
				{
					vector<string*>listing;
					// Works with and without a single argument...
					argo(line, tokens, 1);
					bro.browse(tokens, listing);
					FOR_VECTOR(string*, listing, l)
					printf("%s\n", (*l)->c_str());
				}
				else if(com == "cd")
				{
					if(argo(line, tokens, 1))
					{
						if(bro.change_dir(tokens[0])) printf("Fine.\n");
						else printf("Error changing to '%s'.\n", tokens[0].c_str());
					}
					else printf("Please give me a directory to change to!");
				}
				else if(com == "full")
				{
					if(argo(line, tokens, 1))
					{
						bro.adjust_path(tokens[0]);
						printf("Full path: %s\n", tokens[0].c_str());
					}
					else printf("Please give me a file name to mangle!");
				}
				else if(com == "exit") break;
				else if(com == "help")
				{
					printf("Choose one of these commands:\n");
					printf("pwd - print current directory\n");
					printf("ls [file|dir] - get a file/dir listing\n");
					printf("cd <dir> - change to specified directory\n");
					printf("full <file|dir> - make a path absolute\n");
					printf("exit - go away\n");
				}
				else printf("Unknown command: %s (did you want to type 'help'?)\n", com.c_str());
			}
			else printf("I do not understand.\n");
	
			fprintf(stderr, "> ");
		}
	}
	return 0;
}
