/*
	part of DerMixD
	(c)2004/5 Thomas Orgis, licensed under GPLv2

	audio_buffer.h: audio data storage
*/

/*
	the audio buffer used throughout this project
	flexible in respect to different audio formats (including bits / audio_type)
	
	It provides mainly transparent allocation and reallocation of memory for the wanted number of samples
	together with administrative info as fill or virginity.
	
	...my first template class...
*/

//definition

template <class T, class PT, class RT>
class vgeneric_audio_buffer
{
	public:
		RT channels;
		RT size;
		RT fill;
		PT ptr;
		vgeneric_audio_buffer();
		vgeneric_audio_buffer(unsigned int s);
		vgeneric_audio_buffer(unsigned int c, unsigned int s);
		~vgeneric_audio_buffer();
		unsigned int reallocate(unsigned int s);
		unsigned int reallocate(unsigned int c, unsigned int s);
		virtual void zero();
		volatile bool virgin;
		size_t mysize(){ return sizeof(T)*channels*size; };
};

//implementation

template <class T, class PT, class RT>
vgeneric_audio_buffer<T,PT,RT>::vgeneric_audio_buffer()
{
	#ifdef DEBUG_MEM
	cout << "create audio_buffer" << endl;
	#endif
	ptr = NULL; size = 0; fill = 0; channels = 2;
	virgin = true;
}

template <class T, class PT, class RT>
vgeneric_audio_buffer<T,PT,RT>::vgeneric_audio_buffer(unsigned int s)
{
	#ifdef DEBUG_MEM
	cout << "create audio_buffer" << endl;
	#endif
	ptr = NULL;  channels = 2; size = 0;
	reallocate(s);
}

template <class T, class PT, class RT>
vgeneric_audio_buffer<T,PT,RT>::vgeneric_audio_buffer(unsigned int c, unsigned int s)
{
	#ifdef DEBUG_MEM
	cout << "create audio_buffer" << endl;
	#endif
	ptr = NULL;  channels = c; size = 0;
	reallocate(s);
}
		
template <class T, class PT, class RT>
vgeneric_audio_buffer<T,PT,RT>::~vgeneric_audio_buffer()
{
	#ifdef DEBUG_MEM
	cout << "destruct audio_buffer" << endl;
	#endif
	if(ptr != NULL) delete[] ptr;
}
		
template <class T, class PT, class RT>
unsigned int vgeneric_audio_buffer<T,PT,RT>::reallocate(unsigned int s)
{
	fill = 0;
	if(s != size)
	{
		if(ptr != NULL) delete[] ptr;
		if( (ptr = new T [s*channels]) != NULL ) size = s;
		else size = 0;
		virgin = false; //memory not initialized
	}
	return size;
};

template <class T, class PT, class RT>
unsigned int vgeneric_audio_buffer<T,PT,RT>::reallocate(unsigned int c, unsigned int s)
{
	fill = 0;
	if(s != size || c != channels)
	{
		channels = c;
		reallocate(s);
	}
	return size;
};

template <class T, class PT, class RT>
void vgeneric_audio_buffer<T,PT,RT>::zero()
{
	for(unsigned int i = 0; i < size*channels; ++i) ptr[i] = 0;
	virgin = true;
}

//instances

//with audio_type for normal read/write/store operation
typedef vgeneric_audio_buffer<audio_type, volatile audio_type * volatile, volatile unsigned int> vaudio_buffer;
//more room with int for mixing (might add a float one for internal eq later...?)
typedef vgeneric_audio_buffer<int, int*, unsigned int> vmixer_buffer;
