#include <string>

namespace a
{
	enum type_id
	{
		 invalid=-1
		,dummy
		,raw
		,funky
		,count
	};

	const char* names[count] =
	{
		 "dummy"
		,"raw"
		,"funky"
	};

	const char* invalid_name = "invalid";

#include "blocks/enummap.hxx"
	void print_names(FILE* out)
	{
		for(int i=0; i<count; ++i)
		fprintf(out, "%s\n", names[i]);
	}
}

namespace b
{
	enum type_id
	{
		 invalid=-1
		,dummy=0
		,bleh
		,blah
		,count
	};

	static const char* names[count] =
	{
		 "dummy"
		,"bleh"
		,"blah"
	};

	const char* invalid_name = "invalid";

#include "blocks/enummap.hxx"
	void print_names(FILE* out)
	{
		for(int i=0; i<count; ++i)
		fprintf(out, "%s\n", names[i]);
	}
}

int main(int argc, char **argv)
{
	printf("names in a:\n");
	a::print_names(stdout);
	printf("\n");
	printf("names in b:\n");
	b::print_names(stdout);

	printf("Your mappings in each space:\n");
	for(int i=1; i<argc; ++i)
	{
		// Again, would like the namespace as paramter to a generic printout function... template class after all?
		printf("a: %s -> %i -> %s\n", argv[i], a::name_to_id(argv[i]), a::id_to_name(a::name_to_id(argv[i])));
		printf("b: %s -> %i -> %s\n", argv[i], b::name_to_id(argv[i]), b::id_to_name(b::name_to_id(argv[i])));
	}
	return 0;
}
