#include "../common.h"
#include "../audio_buffer.h"
#include "../output.h"
#include "../input.h"
#include "../mixer_data.h"
#include "../mixer_tools.h"

using namespace std;

int main(int argc, char** argv)
{
	if(argc != 2)
	{
		cout << "I need exactly one existing audio file... not " << argc-1 << "!\n";
		return -1;
	}
	//cout << argv[1] << endl;

	int u = -1;
	string name = argv[argc-1];
	audiodata* ad = get_audiodata(name);
	if(ad->type == UNKNOWN) cout << "Type is unknown; this probably means that the file is non-existent or just really of some unknown type... \n";
	if(! ad->reliable ) cout << "Warning: Info not reliable; meaning either incomplete or at worst only the defaults since no useful info was available. I probably just checked if the file exists and determined file type per name extension.\n";
	if(! ad->exists ) cout << "Ha! The file doesn't even exist! Listing the defaults.\n";
	
	cout << "Type: " << type_string(ad->type) << endl;	
	cout << "Sampling Rate: " << ad->format.rate << endl;
	cout << "Length (Samples): " << ad->length << endl;
	cout << "Length (Time): ";
	fprintf(stdout,"%0.3f",  ((ad->format.rate > 0) ? ((float) ad->length / ad->format.rate) : 0.0));
	cout << "s\n";
	cout << "Channels: " << ad->format.channels << endl;
	cout << "Bytes per Channel " << ad->format.bytes << endl;
		
	for(vector<unsigned long int>::iterator i = ad->specials.begin(); i != ad->specials.end(); ++i)
	{
		cout << "Special Field " << ++u <<": " << *i << endl;
	}
	
	return 0;
}
