#include "../common.h"
#include "../audio_buffer.h"
#include "../audio_functions.h"

void SoundPrint(char lett, audio_type* ar, unsigned int s);
void SoundPrint(char lett, int* ar, unsigned int s);


int main()
{
	audio_buffer ai(2,10000);
	int bi[20000];
	int sv[2];
	sv[0] = 0;
	sv[1] = 0;
	unsigned int a,b;
	for(a = 0; a<10; ++a){ ai.ptr[2*a] = 0; ai.ptr[2*a+1] = 1; }
	ai.fill = 10;
	b = 5;
	double volume = 1;
	fullsample_hqbuff2(ai,bi,b,volume,sv);
	cout << "ChannelTest: 10 Samples A to 5 Samples B\n";
	SoundPrint('A', const_cast<audio_type*> (ai.ptr), 10);
	SoundPrint('B', bi, 5);

	for(a = 0; a<20; ++a){ ai.ptr[2*a] = 10*a; ai.ptr[2*a+1] = 100*a; }
	ai.fill = 20;
	b = 7;
	volume = 1;
	sv[0] = 0;
	sv[1] = 0;
	fullsample_hqbuff2(ai,bi,b,volume,sv);
	cout << "OverallTest: 20 Samples A to 7 Samples B\n";
	SoundPrint('A', const_cast<audio_type*> (ai.ptr), 20);
	SoundPrint('B', bi, 7);

	ai.fill = 3;
	b = 10;

	sv[0] = 0;
	sv[1] = 0;
	fullsample_hqbuff2(ai,bi,b,volume,sv);
	cout << "UpTest: 3 Samples A to 10 Samples B\n";
	SoundPrint('A', const_cast<audio_type*> (ai.ptr), 3);
	SoundPrint('B', bi, 10);

	cout << "compare with normal fullsample:\n";
	fullsample(const_cast<audio_type*> (ai.ptr),ai.fill,bi,b,volume);
	SoundPrint('B', bi, 10);

	volume = 2;

	sv[0] = 0;
	sv[1] = 0;
	fullsample_hqbuff2(ai,bi,b,volume,sv);
	cout << "Now again with volume 2\n";
	SoundPrint('B', bi, 7);

	for(a = 0; a<10000; ++a){ ai.ptr[2*a] = a; ai.ptr[2*a+1] = 2*a; }

	cout << "Speed test: volume = 1.3, a=1000 b=999\n";

	ai.fill = 10000;
	b = 9999;
	volume = 1.3;
	for(unsigned int i=0; i < 1000; ++i)
	{
		fullsample_hqbuff2(ai,bi,b,volume,sv);
	}
}


void SoundPrint(char lett, audio_type* ar, unsigned int s)
{
	for(unsigned int a = 0; a < s; ++a) cout << lett << "[" << 2*a << "] = " << ar[2*a] << ", " << lett << "[" << 2*a+1 << "] = " << ar[2*a+1] << endl;
}

void SoundPrint(char lett, int* ar, unsigned int s)
{
	for(unsigned int a = 0; a < s; ++a) cout << lett << "[" << 2*a << "] = " << ar[2*a] << ", " << lett << "[" << 2*a+1 << "] = " << ar[2*a+1] << endl;
}
