// Test program for dlopen() functionality.
// It even does something useful besides being compilable or not.
#include <dlfcn.h>
#include <stdio.h>

int main(int argc, char **argv)
{
	if(argc>2)
	{
		void *dlhandle = dlopen(argv[1], RTLD_NOW);
		if(dlhandle == NULL)
		{
			const char *msg = dlerror();
			fprintf(stderr, "Failed to dlopen %s: %s\n", argv[1], msg!=NULL ? msg : "?");
			return -1;
		}
		void *sym = dlsym(dlhandle, argv[2]);
		dlclose(dlhandle);
		if(sym != NULL) printf("Symbol %s is at %p in %s.\n", argv[2], sym, argv[1]);
		else printf("Symbol %s is not present in %s.\n", argv[2], argv[1]);

		return (sym == NULL ? -1 : 0);
	}
	// Do nothing, do not care.
	return 0;
}
