# Check if a package exists, use via $(call PKGEXIST, name)
# Result is "yes" or "no".
PKGEXIST = $(shell pkg-config --exists $(1) && echo yes || echo no)
# Same for build testing; tests are complete C++ programs in subdirectory autodetect.
# In the call, make sure to no put in space before the token.
# Example: $(call BUILDTEST,ladspa)
# You can add an argument for appending library flags.
BUILDTEST = $(shell $(CXX) $(CPPFLAGS) $(CXXFLAGS) -o autodetect/$(1).bin autodetect/$(1).cxx $(2) $(LDFLAGS) && echo yes || echo no; rm -f autodetect/$(1).bin)

# Look if certain system properties are given and set default configuration.

ifeq ($(MPG123),)
  $(info Checking for libmpg123...)
  ifeq ($(call PKGEXIST, libmpg123),yes)
    $(info Detected libmpg123 on your system.)
    MPG123:=yes
  endif
endif

ifeq ($(SNDFILE),)
  $(info Checking for libsndfile...)
  ifeq ($(call PKGEXIST, sndfile),yes)
    $(info Detected libsndfile on your system.)
    SNDFILE:=yes
  endif
endif

ifeq ($(VORBISFILE),)
  $(info Checking for libvorbisfile...)
  ifeq ($(call PKGEXIST, vorbisfile),yes)
    $(info Detected libvorbisfile on your system.)
    VORBISFILE:=yes
  endif
endif

ifeq ($(ALSA),)
  $(info Checking for ALSA...)
  ifeq ($(call PKGEXIST, alsa),yes)
    $(info Detected ALSA on your system.)
    ALSA:=yes
  endif
endif

ifeq ($(SOUNDTOUCH),)
  $(info Checking for SoundTouch...)
  ifeq ($(call PKGEXIST, soundtouch-1.4),yes)
    $(info Detected SoundTouch on your system.)
    SOUNDTOUCH:=yes
  endif
endif

ifeq ($(LADSPA),)
  $(info Checking for dlopen as LADSPA prerequesite...)
  ifeq ($(call BUILDTEST,dlopen,-ldl), yes)
    $(info Good, dlopen is there.)
    $(info Checking for LADSPA...)
    ifeq ($(call BUILDTEST,ladspa), yes)
      $(info Detected LADSPA header.)
      LADSPA:=yes
    endif
  endif
endif

ifeq ($(MAGIC),)
  $(info Checking for libmagic ...)
  ifeq ($(call BUILDTEST,magic,-lmagic), yes)
    $(info Good, libmagic is present.)
    MAGIC=yes
  endif
endif
