//<c>   Copyright 1995-2000 by Gerry J. Danen; all rights reserved.

//<t>   Fill a disk

#include"gd_tools.h"


#define SETBUF(b,c)     (memset(&b,c,sizeof(b))) // clear a structure/block


#define BUFR 32765
UCHAR   buf[BUFR+2] ;


void    phase( int ph, char *filename )
{
    FILE        *oFh ;
    int         x, n, ch ;
    ULONG       r = 0 ;

    printf( "Phase %d...\n", ph );

    if ( ph == 1 )
        SETBUF(buf, 0x00);
    else
    if ( ph == 2 )
        SETBUF(buf, 0xFF);
    else
    if ( ph == 3 )
    {
        CLR_BLOCK(buf);
        ch = 0 ;
        LOOP( x, 0, BUFR, 1 )
        {
            ch ++ ;
            if ( ch > 255 )
                ch = 1 ;
            buf[x] = ch ;
        }
    }

    fl_delete( filename );                      // delete first

    oFh = fopen( filename, "wb" );

    FOREVER
    {
        n = fwrite( buf, sizeof(UCHAR), BUFR, oFh );
        if ( n < BUFR )
        {
            printf( " blocks\n" );
            _fcloseall();
            return ;
        }
        r ++ ;
        printf( "\r%lu", r );
    }
}


void    main( int argc, char *argv[] )
{
    STRING      fn = "Danen.$$$" ;

    if ( dr_is_networked( (UCHAR) CurrentDrive() ) )
    {
        printf( "\nDon't want to fill up a network drive, now do we?\n" );
        exit( 1 );
    }

    printf( "\nClearing the unused part of a disk\n" );

    phase( 1, fn );
    phase( 2, fn );
    phase( 3, fn );

    printf( "\nPlease delete %s\n", fn );

    exit( 0 );
}
