#ifdef	WIN32
/************************************************************************/
/*		 snprintf ( Win32  ;()			*/
/************************************************************************/
#include <stdio.h>
#include <stdarg.h>
#include <string.h>
#include <stdlib.h>
#include <unistd.h>
#include "tmalib.h"

#define	SHOW(s) strncat(tmp,s,strlen(s)), cnt+=strlen(s)

int snprintf(char *str, size_t n, const char *format, ...)
{
	char *tokp, ifmt[512], *hdr = ifmt;
	char *buf, *f_buf, *tmp, *f_tmp;
	int cnt=0, m;
	va_list pa;

	strcpy( ifmt, format );	//    
	va_start( pa, format );	// pa -     

	strcpy( str, "(null)" );

	if( strlen( str ) >= n ) m = strlen( str ); else m = n;

	//  .
	buf = malloc( m ); //   n .
	if( !buf ) return( -1 );
	f_buf = buf; //    buf.
	tmp = malloc( m ); //   - // - // - // -
	f_tmp = tmp;
	if( !tmp ){ free( buf ); return( -1 ); }
	tmp[0] = 0;

	while( ( tokp = strchr( hdr, '%' ) ) ) {/*   "%" */
		*tokp++ = '\0';
		SHOW(hdr);		//    "%"
		buf[0] = 0;
		if( strchr( "dufgeisc%", *tokp ) ) { /* ,  
						    
						    */
			switch( *tokp ) {
				case 'd':	// %d &
				case 'u':	// %u &
				case 'i':	// %i
					sprintf( buf, "%i", va_arg(pa,int) );
					break;
				case 's':	// %s
					strcpy( buf, va_arg(pa,char*) );
					break;
				case 'c':	// %c
					buf[0] = va_arg(pa,char);
					buf[1] = '\0';
					break;
				case 'f':	// %f
					sprintf( buf, "%f", va_arg(pa,double) );
					break;
				case 'g':	// %g
					sprintf( buf, "%g", va_arg(pa,double) );
					break;
				case '%':	// %%
					strcpy( buf, "%" );
					break;
			}
			SHOW( buf );	//   
		}
		else {				/*   . -
						        */
			*tmp = *tokp;
			tmp++;
			cnt++;
		}
		hdr = tokp + 1;
	}
	SHOW( hdr );		// ,   ,  
	va_end( pa );

	//  .
	free( f_buf );
	str[0] = 0;
	if( m < strlen( tmp ) ) strncat( str, tmp, strlen( tmp ) );
	else strncat( str, tmp, m );
	free( f_tmp );

	return( 0 );
}
#endif	/* WIN32 */
