#ifndef GLOBAL_H
#define GLOBAL_H
#include <time.h>
#include <limits.h>
#include "../parsecfg/parsecfg.h"
#ifdef	MYDB
#include "mydb.h"
#endif	/* MYDB */

#ifndef	TRUE
#define TRUE	1
#endif

#ifndef	FALSE
#define FALSE	0
#endif

#ifndef	ABORT
#define ABORT	-1
#endif

char *FTN_ADDR;
char *REQ_FILE;
char *OUT_FILE;
char *REP_FILE;
char *DESC_STR;
char *REQEXEC;
char *ORIGIN;
int REQ_EXEC;
int METOD;
int FTN_SYSTEM;
int FTN_SYSTEM_ST;
int SPEED;
long SIZE;
int NFILE;
int FIND;
int SRIF_FREQ;
char CRLF[2];
#ifdef	WIN32
char *TEMP;
#endif	/* WIN32 */
char *REP_HEAD;
char *REP_TAIL;
char *SYSOP;
char *RSYSOP;

char *LIMIT_FILES;
char *LIMIT_SIZE;
char *PASSWDERR;
char *NOTALLOWED;
char *NOTFOUND;

int MAXTIME;

typedef struct limit_type {
    long size_session;
    long file_session;
    long size_day;
    long file_day;
    long size_week;
    long file_week;
    long size_month;
    long file_month;
    int lower_speed;
    int no_limit;
    char *string;
    int protect;
    char *callerid;
    int reqexecbool;
    char *timestr;	// ,   .
} LIMIT_TYPE;

typedef struct req_type {
    char *file;
    char *passwd;
    char *ttt;
} REQ_TYPE;

#if defined(PGSQL) || defined(MY_SQL)
typedef struct sql_type {
    char *host;
    char *port;
    char *dbName;
    char *table_freq;
    char *table_ftn;
    char *user;
    char *passwd;
} SQL_TYPE;
#endif	/* PGSQL || MY_SQL */

typedef struct global_type {
    char *paths;	//      .
    char *head;		//   -   -.
    char *not_found;	// ,   ,       .
    int string_2alt;	//    string  koi8  alt?
    char *ftnaddr;	// FTN address ,    tmafreq.
    int zone, net;	// ZONE:NET
    cfgList **execreq;	//  
} GLOBAL_TYPE;

typedef struct find_type {
    char alias[CHAR_MAX];	// alias  
    char file[CHAR_MAX];	//    
    char path[CHAR_MAX];	//    
    char system;		//  ('a', 'p', 'l')
    char passwd[CHAR_MAX];	//   
    long size;			//   
} FIND_TYPE;

time_t clock_tick;
clock_t start_time;

cfgList *execreq;

/* readcfg.c */
void readcfg(int);
/* koi82alt.c */
char *koi2alt(char*);
/* copyascfile_koi82alt.c */
int copyascfile_koi82alt(char*, char*);
/* execsh */
int execsh(char*);
/* skip_crlf.c */
char *skip_crlf(char*);
/* pkt.c */
char *report2pkt(char*);
/* lock.c */
int LogLock();
int LogUnLock();
/* validname.c */
char *validname(char*);
/* timestr.c */
int ftimestr(char*);

#endif	/* GLOBAL_H */
