// $Id: readcfg.c,v 1.8 2001/02/07 19:00:52 tma Exp $
#include <stdio.h>
#include <limits.h>
#include "tmafreqlib.h"
#include "../parsecfg/parsecfg.h"
#include "../tmalib/tmalib.h"

LIMIT_TYPE *limit;
#if defined(PGSQL) || defined(MY_SQL)
SQL_TYPE *sql;
#endif	/* PGSQL || MY_SQL */

GLOBAL_TYPE *gl;

long *ini_size_limit_session;
long *ini_file_limit_session;
long *ini_size_limit_day;
long *ini_file_limit_day;
long *ini_size_limit_week;
long *ini_file_limit_week;
long *ini_size_limit_month;
long *ini_file_limit_month;
int *ini_lower_speed;
int *ini_no_limit;
int *ini_string_2alt;
int *ini_protect;
int *ini_zone;
int *ini_net;
char **ini_string;
char **ini_callerid;
char **ini_global_paths;
char **ini_global_head;
char **ini_global_not_found;
char **ini_ftnaddr;
char **ini_origin;
cfgList **ini_req=NULL;
char **ini_reqexec;
int *ini_reqexecbool;

char **ini_host;
char **ini_port;
char **ini_dbName;
char **ini_table_freq;
char **ini_table_ftn;
char **ini_user;
char **ini_passwd;
#ifdef	WIN32
#ifndef	MYDB
#define	MYDB
#endif	/* MYDB */
char **ini_temp;
#endif	/* WIN32 */
char **ini_db_path;

char **ini_rep_head;
char **ini_rep_tail;

char **ini_sysop;

char **ini_LIMIT_FILES;
char **ini_LIMIT_SIZE;
char **ini_PASSWDERR;
char **ini_NOTALLOWED;
char **ini_NOTFOUND;

char **ini_timestr;

cfgStruct cfgini[]={
	/* parameter	type		address of variable */
	{"SIZE_LIMIT_SESSION"	,CFG_LONG	,&ini_size_limit_session },
	{"FILE_LIMIT_SESSION"	,CFG_LONG	,&ini_file_limit_session },
	{"SIZE_LIMIT_DAY"	,CFG_LONG	,&ini_size_limit_day },
	{"FILE_LIMIT_DAY"	,CFG_LONG	,&ini_file_limit_day },
	{"SIZE_LIMIT_WEEK"	,CFG_LONG	,&ini_size_limit_week },
	{"FILE_LIMIT_WEEK"	,CFG_LONG	,&ini_file_limit_week },
	{"SIZE_LIMIT_MONTH"	,CFG_LONG	,&ini_size_limit_month },
	{"FILE_LIMIT_MONTH"	,CFG_LONG	,&ini_file_limit_month },
	{"LOWER_SPEED"		,CFG_INT	,&ini_lower_speed },
	{"STRING"		,CFG_STRING	,&ini_string },
	{"NOT_FOUND_ALL"	,CFG_STRING	,&ini_global_not_found },
	{"STRING_2ALT"		,CFG_BOOL	,&ini_string_2alt },
	{"NO_LIMIT"		,CFG_BOOL	,&ini_no_limit },
	{"FTNADDR"		,CFG_STRING	,&ini_ftnaddr },
	{"PROTECT"		,CFG_BOOL	,&ini_protect },
	{"CALLERID"		,CFG_STRING	,&ini_callerid },
	{"ZONE"			,CFG_INT	,&ini_zone },
	{"NET"			,CFG_INT	,&ini_net },

	{"PATHS"		,CFG_STRING	,&ini_global_paths },
	{"HEAD"			,CFG_STRING	,&ini_global_head },

	{"REQ"			,CFG_STRING_LIST,&ini_req },
	{"REQEXEC"		,CFG_STRING	,&ini_reqexec },
	{"SREQEXEC"		,CFG_BOOL	,&ini_reqexecbool },

	{"ORIGIN"		,CFG_STRING	,&ini_origin },

	{"HOST"			,CFG_STRING	,&ini_host },
	{"PORT"			,CFG_STRING	,&ini_port },
	{"DBNAME"		,CFG_STRING	,&ini_dbName },
	{"TABLE_FREQ"		,CFG_STRING	,&ini_table_freq },
	{"TABLE_FTN"		,CFG_STRING	,&ini_table_ftn },
	{"USER"			,CFG_STRING	,&ini_user },
	{"PASSWD"		,CFG_STRING	,&ini_passwd },

	{"DB_PATH"		,CFG_STRING	,&ini_db_path },

#ifdef	WIN32
	{"TEMP"			,CFG_STRING	,&ini_temp },
#endif	/* WIN32 */
	{"REP_HEAD"		,CFG_STRING	,&ini_rep_head },
	{"REP_TAIL"		,CFG_STRING	,&ini_rep_tail },

	{"SYSOP"		,CFG_STRING	,&ini_sysop },

	{"LIMIT_FILES"		,CFG_STRING	,&ini_LIMIT_FILES },
	{"LIMIT_SIZE"		,CFG_STRING	,&ini_LIMIT_SIZE },
	{"PASSWDERR"		,CFG_STRING	,&ini_PASSWDERR },
	{"NOTFOUND"		,CFG_STRING	,&ini_NOTFOUND },
	{"NOTALLOWED"		,CFG_STRING	,&ini_NOTALLOWED },

	// 1.1.4
	{"TIMESTR"		,CFG_STRING	,&ini_timestr },

	/* no more parameters */
	{NULL			,CFG_END	 ,NULL }
};

int section_system(char*);

void readcfg(int flag)
{
    int max, i, WILDMAT;
    char cfg[PATH_MAX];

#ifndef	WIN32
    snprintf( cfg, sizeof(cfg)-1, "%s/%s", CFGDIR, CFGINI );
#else
    // Win32       ,    .
    snprintf( cfg, sizeof(cfg)-1, "%s", CFGINI );
#endif

    limit->timestr = NULL;

    max = cfgParse( cfg, cfgini, CFG_INI );
#ifdef	DEBUG
    printf( "\nmax = %d\n", max );
#endif

    for( i = 0; i < max ; i++ )
    {
	if( !strnicmp( cfgSectionNumberToName(i), "global", 6 ) )
	{
#if defined(PGSQL) || defined(MY_SQL)
	    sql->host = ini_host[i];
	    sql->port = ini_port[i];
	    sql->dbName = ini_dbName[i];
	    sql->table_freq = ini_table_freq[i];
	    sql->table_ftn = ini_table_ftn[i];
	    sql->user = ini_user[i];
	    sql->passwd = ini_passwd[i];
#ifdef	DEBUG
	    printf( "\n[%s]\n", cfgSectionNumberToName(i) );
	    printf( "HOST       : %s\n", sql->host );
	    printf( "PORT       : %s\n", sql->port );
	    printf( "DBNAME     : %s\n", sql->dbName );
	    printf( "TABLE_FREQ : %s\n", sql->table_freq );
	    printf( "TABLE_FTN  : %s\n", sql->table_ftn );
	    printf( "USER       : %s\n", sql->user );
	    printf( "PASSWD     : %s\n", sql->passwd );
#endif /* DEBUG */
#endif /* PGSQL || MY_SQL */
	    gl->paths = ini_global_paths[i];
	    gl->head = ini_global_head[i];
	    gl->string_2alt = ini_string_2alt[i];
	    gl->not_found = ini_global_not_found[i];
	    gl->ftnaddr = ini_ftnaddr[i];
	    gl->zone = ini_zone[i];
	    if( gl->zone == 0 ) gl->zone = DEF_ZONE;
	    gl->net = ini_net[i];
	    if( gl->net == 0 ) gl->zone = DEF_NET;
	    if( ini_rep_head[i] == NULL ) REP_HEAD = NULL;
	    else REP_HEAD = ini_rep_head[i];
	    if( ini_rep_tail[i] == NULL ) REP_TAIL = NULL;
	    else REP_TAIL = ini_rep_tail[i];
	    if( ini_sysop[i] == NULL ) SYSOP = "SysOp";
	    else SYSOP = ini_sysop[i];
	    if( ini_timestr[i] != NULL ) limit->timestr = ini_timestr[i];
	    //    freq
	    if( ini_LIMIT_FILES[i] == NULL ) LIMIT_FILES = "Files limit is exhausted";
	    else LIMIT_FILES = ini_LIMIT_FILES[i];
	    if( ini_LIMIT_SIZE[i] == NULL ) LIMIT_SIZE = "size limit is exhausted";
	    else LIMIT_SIZE = ini_LIMIT_SIZE[i];
	    if( ini_PASSWDERR[i] == NULL ) PASSWDERR = "password error!";
	    else PASSWDERR = ini_PASSWDERR[i];
	    if( ini_NOTALLOWED[i] == NULL ) NOTALLOWED = "Your system is not allowed to freq this file";
	    else NOTALLOWED = ini_NOTALLOWED[i];
	    if( ini_NOTFOUND[i] == NULL ) NOTFOUND = "Not found";
	    else NOTFOUND = ini_NOTFOUND[i];
	    //
	    if( ini_origin[i] != NULL ) ORIGIN = ini_origin[i];
	    else ORIGIN = "tmafreq default origin";
	    gl->execreq = ini_req;
#ifndef	WIN32
	    if( ini_reqexec[i] == NULL ) REQEXEC = "/tmp";
#else
	    if( ini_reqexec[i] == NULL ) REQEXEC = "C:\\";
#endif	/* WIN32 */
	    else REQEXEC = ini_reqexec[i];
#ifdef	MYDB
#ifndef	WIN32
	    if( !ini_db_path[i] ) ini_db_path[i] = strdup( "/tmp" );
	    snprintf( INDEX_FTN, sizeof(INDEX_FTN)-1, "%s/ftn_tbl.idx",
			    ini_db_path[i] );
	    snprintf( INDEX_FREQ, sizeof(INDEX_FREQ)-1, "%s/freq_tbl.idx",
			    ini_db_path[i] );
#else
	    if( !ini_db_path[i] )
	    {
		snprintf( INDEX_FTN, sizeof(INDEX_FTN)-1, "ftn_tbl.idx" );
		snprintf( INDEX_FREQ, sizeof(INDEX_FREQ)-1, "freq_tbl.idx" );
	    }
	    else
	    {
		snprintf( INDEX_FTN, sizeof(INDEX_FTN)-1, "%s\\ftn_tbl.idx",
			ini_db_path[i] );
		snprintf( INDEX_FREQ, sizeof(INDEX_FREQ)-1, "%s\\freq_tbl.idx",
			ini_db_path[i] );
	    }
	    if( ini_temp[i] == NULL ) TEMP = strdup( "C:\\" );
	    else TEMP = ini_temp[i];
#endif	/* WIN32 */
#endif	/* MYDB */

#ifdef	DEBUG
	    printf( "PATHS      : %s\n", gl->paths );
	    printf( "HEAD       : %s\n", gl->head );
	    printf( "STRING_2ALT: %s\n", gl->string_2alt
		? "TRUE" : "FALSE" );	/* 1 is "TRUE", 0 is "FALSE" */
	    printf( "NOT_FOUND_ALL: %s\n", gl->not_found );
	    printf( "FTNADDR    : %s\n", gl->ftnaddr );
	    printf( "ZONE       : %d\n", gl->zone );
	    printf( "NET        : %d\n", gl->net );
	    printf( "TIMESTR    : %s\n", limit->timestr );
	    printf( "REP_HEAD   : %s\n", REP_HEAD );
	    printf( "REP_TAIL   : %s\n", REP_TAIL );
	    printf( "ORIGIN     : %s\n", ORIGIN );
	    printf( "LIMIT_FILES: %s\n", LIMIT_FILES );
	    printf( "LIMIT_SIZE : %s\n", LIMIT_SIZE );
	    printf( "PASSWDERR  : %s\n", PASSWDERR );
	    printf( "NOTALLOWED : %s\n", NOTALLOWED );
	    printf( "NOTFOUND   : %s\n", NOTFOUND );
#ifdef	MYDB
	    printf( "INDEX_FTN  : %s\n", INDEX_FTN );
	    printf( "INDEX_FREQ : %s\n", INDEX_FREQ );
#endif	/* MYDB */
#ifdef	WIN32
	    printf( "TEMP       : %s\n", TEMP );
#endif	/* WIN32 */
	    printf( "REQEXEC    : %s\n", REQEXEC );

	    if( gl->execreq[i] != NULL )
	    {
		for( execreq = gl->execreq[i]; execreq != NULL;
				execreq = execreq->next )
		    printf( "REQ        : %s\n", execreq->str );
	    }
#endif /* DEBUG */
	}
	else
	{
	    if( !flag ) break;
	    //     .
	    WILDMAT = section_system( cfgSectionNumberToName(i) );
	    limit->size_session = ini_size_limit_session[i];
	    limit->file_session = ini_file_limit_session[i];
	    limit->size_day = ini_size_limit_day[i];
	    limit->file_day = ini_file_limit_day[i];
	    limit->size_week = ini_size_limit_week[i];
	    limit->file_week = ini_file_limit_week[i];
	    limit->size_month = ini_size_limit_month[i];
	    limit->file_month = ini_file_limit_month[i];
	    limit->lower_speed = ini_lower_speed[i];
	    limit->string = ini_string[i];
	    limit->no_limit = ini_no_limit[i];
	    limit->protect = ini_protect[i];
	    limit->callerid = ini_callerid[i];
	    limit->reqexecbool = ini_reqexecbool[i];
	    if( ini_timestr[i] != NULL ) limit->timestr = ini_timestr[i];
	    //   ...
	    gl->execreq = ini_req;

#ifdef	DEBUG
	    printf( "\n[%s]\n", cfgSectionNumberToName(i) );
	    printf( "SIZE_LIMIT_SESSION : %ld\n", limit->size_session );
	    printf( "FILE_LIMIT_SESSION : %ld\n", limit->file_session );
	    printf( "SIZE_LIMIT_DAY     : %ld\n", limit->size_day );
	    printf( "FILE_LIMIT_DAY     : %ld\n", limit->file_day );
	    printf( "SIZE_LIMIT_WEEK    : %ld\n", limit->size_week );
	    printf( "FILE_LIMIT_WEEK    : %ld\n", limit->file_week );
	    printf( "SIZE_LIMIT_MONTH   : %ld\n", limit->size_month );
	    printf( "FILE_LIMIT_MONTH   : %ld\n", limit->file_month );
	    printf( "LOWER_SPEED        : %d\n", limit->lower_speed );
	    printf( "STRING             : %s\n", limit->string );
	    printf( "TIMESTR            : %s\n", limit->timestr );
	    printf( "NO_LIMIT           : %s\n", limit->no_limit
		? "TRUE" : "FALSE" );	/* 1 is "TRUE", 0 is "FALSE" */
	    printf( "PROTECT            : %s\n", limit->protect
		? "TRUE" : "FALSE" );	/* 1 is "TRUE", 0 is "FALSE" */
	    printf( "SREQEXEC           : %s\n", limit->reqexecbool
		? "TRUE" : "FALSE" );	/* 1 is "TRUE", 0 is "FALSE" */
	    if( gl->execreq[i] != NULL )
	    {
		for( execreq = gl->execreq[i]; execreq != NULL;
				execreq = execreq->next )
		    printf( "REQ        : %s\n", execreq->str );
	    }
	    printf( "CALLERID           : %s\n", limit->callerid );
	    printf( "WILDMAT            : " );
	    switch( WILDMAT )
	    {
		case FALSE:
		    printf( "FALSE\n" );
		    break;
		case TRUE:
		    printf( "TRUE\n" );
		    break;
		case ABORT:
		    printf( "ABORT\n" );
		    break;
	    }
#endif /* DEBUG */
	    if( WILDMAT == TRUE )
	    {
		if( gl->execreq[i] == NULL ) REQ_EXEC = 0;
		else REQ_EXEC = i;
		break;
	    }
	}
    }
}

//     ,       .
int section_system(char *s)
{
#ifdef	DEBUG
	int i = 0;	//     .
#endif	/* DEBUG */
	int invert;
	char str[CHAR_MAX], str1[CHAR_MAX], *newstr, *tok;

	// .. strtok()      .
	strcpy( str, s );

	newstr = str;
	for( ; (char*)(tok = strtok( newstr, "," )); newstr = 0 )
	{
		invert = -1; //    -1.
		if( tok[0] == '!' ) //    '!'
		{
			invert = 0; //     0.
			tok++;	//    , ..
				//   --- '!'.
		}
		else if( tok[0] == '/' ) //    '/'
		{
			//     --- 
			//    .
			snprintf( str1, sizeof(str1)-1, "%d:%d%s",
					gl->zone, gl->net, tok );
			tok = str1; //    .
		}
#ifdef	DEBUG
		printf( "section_system[%d]: \"%s\"%s",
				i++, tok, invert ? "" : " - inverted\n");
#endif	/* DEBUG */
		//   ,      
		//  '!',      .
		if( wildmat( FTN_ADDR, tok ) == TRUE )
		{
			if( !invert )
			{
#ifdef	DEBUG
				printf( "FTN_ADDR ignored: %s! return\n",
						FTN_ADDR );
#endif	/* DEBUG */
				return( FALSE );
			}
#ifdef	DEBUG
			printf( " -- ok\n" );
#endif	/* DEBUG */
			return( TRUE );
		}
#ifdef	DEBUG
			printf( "\n" );
#endif	/* DEBUG */
	}
	return( FALSE );
}
