#ifdef	WIN32
#ifndef	SRIF
#define	SRIF
#endif	/* SRIF */
#endif	/* WIN32 */

#ifdef	SRIF

#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <limits.h>
#include <locale.h>
#include <time.h>
#include "tmafreqlib.h"
#include "../tmalib/tmalib.h"
#include "../version.h"

GLOBAL_TYPE *gl;

unsigned long seq=0xFFFFFFFF;

int getzone(char *addrstring)
{
	char *addr, tmp[CHAR_MAX];

	strcpy( tmp, addrstring );

	//   : 65535:65535/65535.65535
	//    ':'
	addr = strchr( tmp, ':' );
	if( addr == NULL ) return( 0 );
	*addr = 0; //  \0
	return( atoi( tmp ) );
}

int getnet(char *addrstring)
{
	char *addr1, *addr2, tmp[CHAR_MAX];

	strcpy( tmp, addrstring );

	//   : 65535:65535/65535.65535
	//    ':'
	addr1 = strchr( tmp, ':' );
	if( addr1 == NULL ) return( 0 );
	*addr1 = 0; //  \0
	//    '/'
	addr2 = strchr( addr1+1, '/' );
	if( addr2 == NULL ) return( 0 );
	*addr2 = 0; //  \0
	//  net  ,     ':'  '/'
	strcpy( tmp, addr1+1 );

	return( atoi( tmp ) );
}

int getnode(char *addrstring)
{
	char *addr1, *addr2, tmp[CHAR_MAX];

	strcpy( tmp, addrstring );

	//   : 65535:65535/65535.65535
	//    '/'
	addr1 = strchr( tmp, '/' );
	if( addr1 == NULL ) return( 0 );
	*addr1 = 0; //  \0
	//    '.'
	addr2 = strchr( addr1+1, '.' );
	//   '.' ---    .
	if( addr2 != NULL ) *addr2 = 0; //  \0
	//  net  ,     '/'  '.'
	strcpy( tmp, addr1+1 );

	return( atoi( tmp ) );
}

int getpoint(char *addrstring)
{
	char *addr, tmp[CHAR_MAX];

	strcpy( tmp, addrstring );

	//   : 65535:65535/65535.65535
	//    '.'
	addr = strchr( tmp, '.' );
	if( addr == NULL ) return( 0 );
	addr++; //    1
	return( atoi( addr ) );
}

int validaddr(char *addrstring)
{
	int i;

	i = strspn( addrstring, "0123456789:/." );
	if( i == strlen( addrstring ) ) return( 0 );
	return( -1 );
}

char *engms[]={"Jan","Feb","Mar","Apr","May","Jun",
			   "Jul","Aug","Sep","Oct","Nov","Dec"};

/*	  				*/
char *createmsgdate()
{
    static char s[CHAR_MAX];
    time_t timv = time( 0 );
    struct tm *t = localtime( &timv );

#ifndef	WIN32
    snprintf( s, sizeof(s)-1, "%02d %3s %02d  %02d:%02d:%02d", t->tm_mday,
		    engms[t->tm_mon], t->tm_year%100, t->tm_hour, t->tm_min,
		    t->tm_sec);
#else
    sprintf( s, "%02d %3s %02d  %02d:%02d:%02d", t->tm_mday, engms[t->tm_mon],
		    t->tm_year%100, t->tm_hour, t->tm_min, t->tm_sec);
#endif	/* WIN32 */
#ifdef	DEBUG
    printf( "createmsgdate() returned \"%s\"\n", s );
#endif

    return( s );
}

unsigned long sequencer()
{
	if( seq == 0xFFFFFFFF )
		seq = time( NULL );
	else
		if( time( NULL ) > seq )
			seq = time( NULL );
		else seq++;
	return( seq );
}

void pinor( int t1, FILE *f )
{
	fputc( ( t1 & 0xFF ), f );
	fputc( ( ( t1 >> 8 ) & 0xFF ), f );
}

// attribute
#define	_KS	0x80	// Kill after Sent

//  PKT - (Type 2+) (FSC-0048.002)
int createpkt(char *youraka, char *sysaka, char *file2get, char *file2place)
{
	FILE *f, *sf;
	time_t x;
	struct tm *ttime;
	int i;
	char str[CHAR_MAX];
	char password[8]="\x0\x0\x0\x0\x0\x0\x0\x0";	//   

	f = NULL;
	f = fopen( file2place, "wb" );
	if( !f ) return( -1 );

	time( &x );
	ttime = localtime( &x );

	//    (Type 2+)
	pinor( getnode( youraka ), f );
	pinor( getnode( sysaka ), f );
	pinor( ttime->tm_year+1900, f );
	pinor( ttime->tm_mon, f );
	pinor( ttime->tm_mday, f );
	pinor( ttime->tm_hour, f );
	pinor( ttime->tm_min, f );
	pinor( ttime->tm_sec, f );
	fputc( 0, f ); fputc( 0, f );	// baud
	fputc( 2, f ); fputc( 0, f );	// \x02\x00

	//  point ---  -1
	if( getpoint( youraka ) != 0 )
		pinor( -1, f );
	else
		pinor( getnet( youraka ), f );

	pinor( getnet( sysaka ), f );

	fputc( 0, f ); // ProductCode
	fputc( 0, f ); // Revision major

	for( i = 0; i < 8; i++ ) fputc( password[i], f );

	pinor( getzone( youraka ), f );	// origZone
	pinor( getzone( sysaka ), f );	// destZone

	if( getpoint( youraka ) != 0 )	// AuxNet
		pinor( getnet( youraka ), f );
	else
		pinor( 0, f );

	fputc( 0, f ); fputc( 1, f );
	fputc( 0, f ); fputc( 0, f );
	fputc( 1, f ); fputc( 0, f );

	pinor( getzone( youraka ), f );	// origZone
	pinor( getzone( sysaka ), f );	// destZone

	pinor( getpoint( youraka ), f ); // origPoint
	pinor( getpoint( sysaka ), f );	 // destPoint

	fputc( 0, f ); fputc( 0, f );
	fputc( 0, f ); fputc( 0, f );

	//     .
	fputc( 2, f ); fputc( 0, f );
	pinor( getnode( youraka ), f );
	pinor( getnode( sysaka ), f );
	pinor( getnet( youraka ), f );
	pinor( getnet( sysaka ), f );
	pinor( _KS, f ); // Kill
	fputc( 0, f ); fputc( 0, f );
	fputs( createmsgdate(), f ); fputc( 0, f ); // date
	//   
	fputs( "SysOp", f ); fputc( 0, f ); // To:
	fputs( "TMAFREQ processor", f ); fputc( 0, f ); // From:
	fputs( "file request", f ); fputc( 0, f ); // Subj

	if( getpoint( youraka ) ) fprintf( f, "\001FMTP %d\r",
			getpoint( youraka ) );
	if( getpoint( sysaka ) ) fprintf( f, "\001TOPT %d\r",
			getpoint( sysaka ) );
	fprintf( f, "\001INTL %d:%d/%d %d:%d/%d\r",
		getzone( sysaka ), getnet( sysaka ), getnode( sysaka ),
		getzone( youraka ), getnet( youraka ), getnode( youraka ) );

	fprintf( f, "\001MSGID: %s %08lx\r", youraka, sequencer() );

	sf = NULL;
	sf = fopen( file2get, "r" ); // "rt"
	if( sf != NULL )
	{
		while( fgets( str, sizeof(str)-1, sf ) != NULL )
		{
			skip_crlf( str );
			fputs( str, f );
			fputc( '\r', f );
		}
		fclose( sf );
	}

	fputc( '\r', f );
#ifndef	WIN32
	fprintf( f, "--- tmafreq ver. %d.%d.%d (compiled at %s %s)\r",
#else
	fprintf( f, "--- tmafreq ver. %d.%d.%d-win32 (compiled at %s %s)\r",
#endif	/* WIN32 */
			VERSION_MAJOR, VERSION_MINOR, PATHLEVEL,
			__TIME__, __DATE__ );
	fprintf( f, " * Origin: %s (%s)\r", koi2alt( ORIGIN ), youraka );

	//  
	fputc( 0, f );

	//  PKT -
	fputc( 0, f ); fputc( 0, f );
	fclose( f );
	return( 0 );
}

char *report2pkt(char *report)
{
	static char file[PATH_MAX];

	//     FTN -  ---  NULL
	if( validaddr( gl->ftnaddr ) || validaddr( FTN_ADDR ) ) return( NULL );
#ifndef	WIN32
	snprintf( file, sizeof(file)-1, "/tmp/%08lx.pkt", sequencer() );
#else
	sprintf( file, "%s%08lx.PKT", TEMP, sequencer() );
#endif	/* WIN32 */
	//      pkt - ---  NULL
	if( createpkt( gl->ftnaddr, FTN_ADDR, report, file ) ) return( NULL );
	return( file );
}

#endif	/* SRIF */
