#ifdef	WIN32
#ifndef	MYDB
#define	MYDB
#endif	/* MYDB */
#endif	/* WIN32 */
 
#ifdef	MYDB

#include <stdio.h>
#include "mydb.h"

char INDEX_FTN[512];
char INDEX_FREQ[512];

int write_ftn_idx()
{
	FILE *f;

	f = fopen( INDEX_FTN, "ab" );
	if( !f )
	{
#ifdef	DEBUG
		fprintf( stderr, "Critical ERROR (fopen return NULL)!\n" );
#endif	/* DEBUG */
		return( -1 );
	}

	// write to idx
	fwrite( &FTN_TABLE, sizeof( struct ftn_table ), 1, f );

	fclose( f );
	return( 0 );
}

int read_ftn_idx(int skip)
{
	FILE *f;
	int size = sizeof( struct ftn_table );

	f = fopen( INDEX_FTN, "rb" );
	if( !f )
	{
#ifdef	DEBUG
		fprintf( stderr, "Critical ERROR (fopen return NULL)!\n" );
#endif	/* DEBUG */
		return( -1 );
	}

	//    ...
	(void)fseek( f, 0L, SEEK_SET );

#ifdef	DEBUG
	printf( "skip = %d\n", skip );
#endif	/* DEBUG */

	//      skip.
	if( fseek( f, ( skip * size ), SEEK_CUR ) )
	{
		fclose( f );
#ifdef	DEBUG
		fprintf( stderr, "Critical ERROR (fseek return -1)\n" );
#endif	/* DEBUG */
		return( -1 );
	}

	// read from idx
	if( fread( &FTN_TABLE, size, 1, f ) == 0 )
	{
		fclose( f );
#ifdef	DEBUG
		fprintf( stderr,
			"Critical ERROR (fread return 0 bytes)!\n" );
#endif	/* DEBUG */
		return( -1 );
	}

	fclose( f );
	return( 0 );
}

int write_freq_idx()
{
	FILE *f;

	f = fopen( INDEX_FREQ, "ab" );
	if( !f )
	{
#ifdef	DEBUG
		fprintf( stderr, "Critical ERROR (fopen return NULL)!\n" );
#endif	/* DEBUG */
		return( -1 );
	}

	// write to idx
	fwrite( &FREQ_TABLE, sizeof( struct freq_table ), 1, f );

	fclose( f );
	return( 0 );
}

int read_freq_idx(int skip)
{
	FILE *f;
	int size = sizeof( struct freq_table );

	f = fopen( INDEX_FREQ, "rb" );
	if( !f )
	{
#ifdef	DEBUG
		fprintf( stderr, "Critical ERROR (fopen return NULL)!\n" );
#endif	/* DEBUG */
		return( -1 );
	}

	//    ...
	(void)fseek( f, 0L, SEEK_SET );

#ifdef	DEBUG
	printf( "skip = %d\n", skip );
#endif	/* DEBUG */

	//      skip.
	if( fseek( f, ( skip * size ), SEEK_CUR ) )
	{
		fclose( f );
#ifdef	DEBUG
		fprintf( stderr, "Critical ERROR (fseek return -1)\n" );
#endif	/* DEBUG */
		return( -1 );
	}

	// read from idx
	if( fread( &FREQ_TABLE, size, 1, f ) == 0 )
	{
		fclose( f );
#ifdef	DEBUG
		fprintf( stderr,
			"Critical ERROR (fread return 0 bytes)!\n" );
#endif	/* DEBUG */
		return( -1 );
	}

	fclose( f );
	return( 0 );
}
#endif	/* MYDB */
