#ifdef	WIN32
/*  Win32  . */
int LogLock(){ return (0); };
int LogUnLock(){ return(0); };
#else

#include <sys/file.h>
#include <sys/types.h>
#include <sys/stat.h>
#include <fcntl.h>
#include <unistd.h>
#include "tmafreqlib.h"

#define	DEF_SLEEP	15	/* 15 sec */

int fd;

int LogLock()
{
	int err, i = DEF_SLEEP;

	//   -  
	fd = open( LOGFILE, O_RDONLY | O_CREAT , 0660 );
	if( fd == -1 ) return( -1 );

	//  mailbox ,   DEF_SLEEP sec.
	while( i-- >= 0 )
	{
		err = flock( fd, LOCK_EX | LOCK_NB );
		if( err != -1 ) break;
		sleep( 1 );
	}
	if( err == -1 ) return( -1 );
	return( 0 );
}

int LogUnLock()
{
	if( flock( fd, LOCK_NB | LOCK_UN ) == -1 )
	{
		close( fd );
		return( -1 );
	}

	close( fd );
	return( 0 );
}
#endif	/* WIN32 */
