/******************************************************************
 * File: execsh.c
 * Created at Sun Nov 21 12:05:23 1999 by pk // aaz@ruxy.org.ru
 * Base version of this file was taken from by Eugene Crosser's ifcico 
 * $Id: execsh.c,v 1.1.1.1 2000/12/05 15:09:51 tma Exp $
 * modifed by Maxim Timofeyev
 ******************************************************************/
#ifndef	WIN32
#include <sys/types.h>
#include <sys/wait.h>
#include <errno.h>
#include <unistd.h>
#include <stdio.h>
#include <string.h>
#include <fcntl.h>
#endif	/* WIN32 */
#include <stdlib.h>
#include "tmafreqlib.h"

#ifndef	WIN32
#ifndef	SHELL
#define	SHELL "/bin/sh"
#endif	/* SHELL */
#endif	/* WIN32 */

int execsh(char *cmd)
{
#ifndef	WIN32
	pid_t pid;
	int status, rc, sverr;

	if( !( pid = fork() ) )
	{
		fclose( stdout );
		fclose( stderr );
		rc = execl( SHELL, "sh", "-c", cmd, NULL );
		exit( -1 );
	}
	do
	{
		rc = wait( &status ); sverr = errno;
	}
	while( ( ( rc > 0 ) && ( rc != pid ) ) ||
	    ( ( rc == -1 ) && ( sverr == EINTR ) ) );
	if( rc < 0 )
	{
		/*log("wait() returned %d, status %d,%d",rc,status>>8,status&0xff);*/
		return( -1 );
	}
	return( WEXITSTATUS( status ) );
#else
	return( system( cmd ) );
#endif	/* WIN32 */
}
