#include <limits.h>
#include <time.h>
#include <stdio.h>
#include "includes.h"

#ifdef	WIN32
#ifndef	MYDB
#define	MYDB
#endif	/* MYDB */
#undef	PGSQL
#undef	MY_SQL
#undef	DESC
#endif	/* WIN32 */

/*	  				*/
char *timenow()
{
    static char s[CHAR_MAX];
    time_t timv = time( 0 );
    struct tm *local_tm = localtime( &timv );

    strftime( s, sizeof(s)-1, "%d/%m/%Y %H:%M:%S", local_tm );

#ifdef	DEBUG
    printf( "timenow() returned \"%s\"\n", s );
#endif

    return( s );
}

/*	  				*/
char *today()
{
    static char s[CHAR_MAX];

    time_t timv = time( 0 );
    struct tm *local_tm = localtime( &timv );

//     PostgreSQL  MySQL.
// TODO -    .
#ifdef	PGSQL
    strftime( s, sizeof(s)-1, "%m-%d-%Y", local_tm );
#endif	/* PGSQL */
#ifdef	MY_SQL
    strftime( s, sizeof(s)-1, "%Y-%m-%d", local_tm );
#endif	/* MY_SQL */
#ifdef	MYDB
    strftime( s, sizeof(s)-1, "%d/%m/%Y", local_tm );
#endif	/* MYDB */

#ifdef	DEBUG
    printf( "today() returned \"%s\"\n", s );
#endif

    return( s );
}

/*	 01   			*/
char *month1()
{
    static char s[CHAR_MAX];
    time_t timv = time( 0 );
    struct tm *local_tm = localtime( &timv );

//     PostgreSQL  MySQL.
// TODO -    .
#ifdef	PGSQL
    strftime( s, sizeof(s)-1, "%m-01-%Y", local_tm );
#endif	/* PGSQL */
#ifdef	MY_SQL
    strftime( s, sizeof(s)-1, "%Y-%m-01", local_tm );
#endif	/* MY_SQL */
#ifdef	MYDB
    strftime( s, sizeof(s)-1, "01/%m/%Y", local_tm );
#endif	/* MYDB */

#ifdef	DEBUG
    printf( "month1() returned \"%s\"\n", s );
#endif

    return( s );
}

/*	    		*/

char *week()
{
    static char s[CHAR_MAX];
    time_t timv = time( 0 );
    struct tm *local_tm;
    int week_day;

    local_tm = localtime( &timv );
    week_day = local_tm->tm_wday;

    // week_day:   (0)   (6)
    //  -   7- .
    if( week_day == 0 ) week_day = 7;

    //  1 (),    ,
    // ..    .
    if( week_day > 1 ) timv -= ( week_day - 1 ) * 24 * 60 * 60;

    local_tm = localtime( &timv );

//     PostgreSQL  MySQL.
// TODO -    .
#ifdef	PGSQL
    strftime( s, sizeof(s)-1, "%m-%d-%Y", local_tm );
#endif	/* PGSQL */
#ifdef	MY_SQL
    strftime( s, sizeof(s)-1, "%Y-%m-%d", local_tm );
#endif	/* MY_SQL */
#ifdef	MYDB
    strftime( s, sizeof(s)-1, "%d/%m/%Y", local_tm );
#endif	/* MYDB */

#ifdef	DEBUG
    printf( "week() returned \"%s\"\n", s );
#endif

    return( s );
}

//  
void timer_init()
{
    clock_tick = CLOCKS_PER_SEC;
    start_time = clock();		//  .
}

//  
char *timer_stop()
{
    float float_clock_tick = clock_tick;
    float float_elapsed_time;
    clock_t elapsed_time = clock() - start_time;
    static char t[50];
    float_elapsed_time = elapsed_time;

    sprintf( t, "%.2f", float_elapsed_time / float_clock_tick );

    return( t );
}
