#ifdef	WIN32
#ifndef	SRIF
#define	SRIF
#endif	/* SRIF */
#include <process.h>
#endif	/* WIN32 */

#ifdef	SRIF

/*
 * S  tandard
 * R  equest
 * I  nformation
 * F  ile
 */

#include <stdio.h>
#include <string.h>
#include <stdlib.h>
#include <limits.h>
#include "includes.h"
#ifdef	DEBUG_SRIF
#include <unistd.h>
#endif	/* DEBUG_SRIF */

char *SRIF_AKA="0:0/0.0";
int SRIF_BAUD=0;
char *SRIF_REQ=NULL;
char *SRIF_OUT=NULL;
int SRIF_SYSTEM=UNPROTECT;
/*  ... */
int SRIF_SYSTEM_ST=ALL;
char *CALLER_ID=NULL;

int opt_arg(char*, char*, char*);

int srif_main(char *srif_file)
{
	char str[CHAR_MAX], opt[CHAR_MAX], arg[CHAR_MAX];
	FILE *srif_f;
#ifdef	DEBUG_SRIF
	char debug_srif[PATH_MAX];
	FILE *debug_f;

#ifndef	WIN32
	snprintf( debug_srif, sizeof(debug_srif)-1, "%s.%d",
			DEBUG_SRIF, getpid() );
#else
	sprintf( debug_srif, "%8d.srf", getpid() );
#endif	/* WIN32 */

	if( ( debug_f = fopen( debug_srif, "w" ) ) == NULL )
		log( "Can't open DEBUG_SRIF_FILE \"%s\"!", debug_srif );
#endif	/* DEBUG_SRIF */

	if( ( srif_f = fopen( srif_file, "r" ) ) == NULL )
	{
		log( "SRIF_FILE \"%s\" file don't exist!", srif_file );
		rep_file( "ERROR: Internal error at %s in %d!",
				__FILE__, __LINE__ );
		rep_file( "Please return this message (with kludges)..." );
		rep_file( "SRIF error!" );

		return( -1 );
	}

	RSYSOP = NULL;
	while( fgets( str, sizeof(str)-1, srif_f ) != NULL )
	{
		skip_crlf( str );
		opt_arg( str, opt, arg );
#ifdef	DEBUG
		printf( "srif:        opt: \"%s\", arg: \"%s\"\n", opt, arg );
#endif	/* DEBUG */
#ifdef	DEBUG_SRIF
		//     DEBUG -.
		if( debug_f ) fputs( str, debug_f );
#endif	/* DEBUG_SRIF */
		if( strcasecmp( opt, "sysop" ) == 0 ) RSYSOP = strdup( arg );
		else if( strcasecmp( opt, "aka" ) == 0 )
		{
			//    AKA
			if( !strcmp( SRIF_AKA, "0:0/0.0" ) )
			{
				SRIF_AKA = strdup( arg );
				//  ,     '@'
				strtok( SRIF_AKA, "@" );
			}
		}
		else if( strcasecmp( opt, "baud" ) == 0 )
			SRIF_BAUD = atoi( arg );
		else if( strcasecmp( opt, "time" ) == 0 )
			MAXTIME = atoi( arg );
		else if( strcasecmp( opt, "requestlist" ) == 0 )
			SRIF_REQ = strdup( arg );
		else if( strcasecmp( opt, "responselist" ) == 0 )
			SRIF_OUT = strdup( arg );
		else if( strcasecmp( opt, "remotestatus" ) == 0 )
		{
			if( strcasecmp( arg, "protected" ) == 0 )
				SRIF_SYSTEM = PROTECT;
			if( strcasecmp( arg, "unprotected" ) == 0 )
				SRIF_SYSTEM = UNPROTECT;
		}
		else if( strcasecmp( opt, "systemstatus" ) == 0 )
		{
			if( strcasecmp( arg, "listed" ) == 0 )
				SRIF_SYSTEM_ST = LISTED;
			if( strcasecmp( arg, "unlisted" ) == 0 )
				SRIF_SYSTEM_ST = ALL;
		}
		else if( strcasecmp( opt, "callerid" ) == 0 )
			CALLER_ID = strdup( arg );
	}

	fclose( srif_f );
	if( !RSYSOP ) RSYSOP = strdup( "SysOp" );
#ifdef	DEBUG_SRIF
	//  DEBUG -,  .
	if( debug_f ) fclose( debug_f );
#endif	/* DEBUG_SRIF */
	//     : SRIF_REQ  SRIF_OUT.
	//  ,   .
	if( !SRIF_REQ || !SRIF_OUT )
	{
		log( "Critical error: SRIF_REQ or SRIF_OUT == NULL!" );
		return( -1 );
	}
	return( 0 );
}

//   opt  arg   str.
int opt_arg(char *str, char *opt, char *arg)
{
	char *argtmp, *opttmp;

	opttmp = str;
	strcpy( opt, opttmp );
	strcpy( arg, "noarg" );

	argtmp = strchr( opttmp, ' ' );
	if( !argtmp ) return( -1 );

	*argtmp = 0;
	++argtmp;

	strcpy( arg, argtmp );
	strcpy( opt, opttmp );

#ifdef	DEBUG
	printf( "opt: \"%s\", arg: \"%s\"\n", opt, arg );
#endif	/* DEBUG */
	return( 0 );
}

#endif	/* SRIF */
