#include <stdio.h>
#include <sys/stat.h>
#include <unistd.h>
#include <errno.h>
#include "includes.h"

REQ_TYPE *req;
FIND_TYPE *find;

long sizefile()
{
    struct stat	statv;
    char f_path[PATH_MAX];

#ifndef	WIN32
    snprintf( f_path, sizeof(f_path)-1, "%s/%s", find->path, find->file );
#else
    snprintf( f_path, sizeof(f_path)-1, "%s\\%s", find->path, find->file );
#endif	/* WIN32 */

    if( stat( f_path, &statv ) )
    {
	if( errno != ENOENT )
	    log( "Freq file \"%s\" - unknown error!", req->file );
	find->size = 0;
	return( 0 );
    }
    find->size = statv.st_size;
#ifdef	DEBUG
    printf( "File: \"%s\", size: %ld\n", f_path, find->size );
#endif

    return( find->size );
}
