#include <stdio.h>
#include <stdarg.h>
#include <string.h>
#include <stdlib.h>
#include <unistd.h>
#include "includes.h"

#ifdef	WIN32
#undef	DESC
#endif	/* WIN32 */

#define	SHOW(s) fputs(s,repfile), cnt+=strlen(s)

int rep_file(const char *format, ...)
{
	FILE *repfile;
	char *tokp, ifmt[CHAR_MAX], *hdr = ifmt, bbuf[CHAR_MAX];
	char *buf, *tmp_buf;
	int cnt=0, len;
	va_list pa;

	//     --- .
	if( REP_FILE == NULL ) return( 0 );

	//       (char*)buf.
#ifdef	DESC
	if( DESC_STR == NULL ) len = CHAR_MAX;
	else
	{
		len = strlen( DESC_STR );
		if( len < CHAR_MAX ) len = CHAR_MAX;
	}
#else
	len = CHAR_MAX;
#endif	/* DESC */

	//    (char*)buf
	buf = (char*)malloc( len +  1 );
	if( buf == NULL ) return( -1 );	// malloc  NULL.
	//  ...
	tmp_buf = buf;

	strcpy( ifmt, format );	//    
	va_start( pa, format );	// pa -     

	if( ( repfile = fopen( REP_FILE, "a" ) ) == NULL ) return( -1 );

	while( ( tokp = strchr( hdr, '%' ) ) ) {/*   "%" */
		*tokp++ = '\0';
		SHOW(hdr);		//    "%"
		if( strchr( "dufgeisc%", *tokp ) ) { /* ,  
						    
						    */
			switch( *tokp ) {
				case 'd':	// %d &
				case 'u':	// %u &
				case 'i':	// %i
					snprintf( bbuf, sizeof(bbuf)-1, "%i",
							va_arg( pa, int ) );
					strncpy( buf, bbuf, len );
					strcat( buf, "\0" );
					break;
				case 's':	// %s
					strncpy( buf, va_arg( pa, char* ),
							len );
					strcat( buf, "\0" );
					break;
				case 'c':	// %c
					buf[0] = va_arg( pa, char );
					buf[1] = '\0';
					break;
				case 'f':	// %f
					snprintf( bbuf, sizeof(bbuf)-1, "%f",
							va_arg( pa, double ) );
					strncpy( buf, bbuf, len );
					strcat( buf, "\0" );

					break;
				case 'g':	// %g
					snprintf( bbuf, sizeof(bbuf)-1, "%g",
							va_arg( pa, double ) );
					strncpy( buf, bbuf, len );
					strcat( buf, "\0" );
					break;
				case '%':	// %%
					strcpy( buf, "%" );
					break;
			}
			SHOW( buf );	//   
		}
		else {				/*   . -
						        */
			fputc( *tokp, repfile );
			cnt++;
		}
		hdr = tokp + 1;
	}
	SHOW( hdr );		// ,   ,  
	va_end( pa );

	// .. SRIF    freq-  ---
	//    DOS , ..    AS IS.
	// ( x0D, x0A)
	fprintf( repfile, "%s", CRLF );

	fclose( repfile );

	free( tmp_buf );

	return( 0 );
}
