#ifdef	WIN32
#ifndef	MYDB
#define	MYDB
#endif	/* MYDB */
#undef	PGSQL
#undef	MY_SQL
#undef	DESC
#endif	/* WIN32 */

#ifdef	PGSQL

#include <stdio.h>
#include <string.h>
#include <stdlib.h>
#include "includes.h"

LIMIT_TYPE *limit;
REQ_TYPE *req;
SQL_TYPE *sql;
FIND_TYPE *find;

void exit_nicely(PGconn *conn)
{
    if( res != NULL ) PQclear( res );
    if( res_tmp != NULL ) PQclear( res_tmp );
    PQfinish( conn );
}

int init_pgsql()
{
    char   *pgoptions, *pgtty, err[CHAR_MAX];

    if( !sql->host || !sql->dbName || !sql->port )
    {
	    log( "Critical ERROR! Show HOST or DBNAME or PORT!" );
	    return( -1 );
    }

    pgoptions = NULL;		/* special options to start up the backend
				 * server */
    pgtty = NULL;		/* debugging tty for the backend server */

    /* make a connection to the database */
    conn = PQsetdb( sql->host, sql->port, pgoptions, pgtty, sql->dbName );

    /* check to see that the backend connection was successfully made */
    if( PQstatus( conn ) == CONNECTION_BAD )
    {
	log( "Connection to database '%s' failed.", sql->dbName );
	snprintf( err, sizeof(err)-1, "%s", PQerrorMessage( conn ) );
	skip_crlf( err );
	log( "SQL: %s", err );

#ifdef	DEBUG
	printf( "init_pgsql() - connect to database failed...\n" );
#endif
	return( -1 );
    }

#ifdef	DEBUG
    printf( "init_pgsql() - connect Ok.\n" );
#endif

    return( 0 );
}

long size_dayDB()
{
    char z[1024];

    //        .
    snprintf( z, sizeof(z)-1, "SELECT SUM(size) FROM %s WHERE " \
     "addr='%s' AND date='%s'", sql->table_ftn, FTN_ADDR, today() );
    //  size   .
    res_tmp = PQexec( conn, z );
    if( PQresultStatus( res_tmp ) != PGRES_TUPLES_OK )
    {
	log( "SELECT * FROM command failed!" );
	PQclear( res_tmp );
	return( 0 );
    }

    return( atol( PQgetvalue( res_tmp, 0, 0 ) ) );
}

int file_dayDB()
{
    char z[1024];

    //   -     .
    snprintf( z, sizeof(z)-1, "SELECT COUNT(size) FROM %s WHERE " \
     "addr='%s' AND date='%s'", sql->table_ftn, FTN_ADDR, today() );
    //  size   .
    res_tmp = PQexec( conn, z );
    if( PQresultStatus( res_tmp ) != PGRES_TUPLES_OK )
    {
	log( "SELECT * FROM command failed!" );
	PQclear( res_tmp );
	return( 0 );
    }

    return( atoi( PQgetvalue( res_tmp, 0, 0 ) ) );
}

long size_weekDB()
{
    char z[1024];

    //         
    //   .
    if( !strcmp( week(), today() ) )
    snprintf( z, sizeof(z)-1, "SELECT SUM(size) FROM %s WHERE " \
     "addr='%s' AND date = '%s'", sql->table_ftn, FTN_ADDR, today() );
    else
    snprintf( z, sizeof(z)-1, "SELECT SUM(size) FROM %s WHERE " \
     "addr='%s' AND date > '%s' AND date <= '%s'",
      sql->table_ftn, FTN_ADDR, week(), today() );
    //  size   .
    res_tmp = PQexec( conn, z );
    if( PQresultStatus( res_tmp ) != PGRES_TUPLES_OK )
    {
	log( "SELECT * FROM command failed!" );
	PQclear( res_tmp );
	return( 0 );
    }

    return( atol( PQgetvalue( res_tmp, 0, 0 ) ) );
}

int file_weekDB()
{
    char z[1024];

    //   -      
    //   .
    if( !strcmp( week(), today() ) )
    snprintf( z, sizeof(z)-1, "SELECT COUNT(size) FROM %s WHERE " \
     "addr='%s' AND date = '%s'", sql->table_ftn, FTN_ADDR, today() );
    else
    snprintf( z, sizeof(z)-1, "SELECT COUNT(size) FROM %s WHERE " \
     "addr='%s' AND date > '%s' AND date <= '%s'",
      sql->table_ftn, FTN_ADDR, week(), today() );
    //  size   .
    res_tmp = PQexec( conn, z );
    if( PQresultStatus( res_tmp ) != PGRES_TUPLES_OK )
    {
	log( "SELECT * FROM command failed!" );
	PQclear( res_tmp );
	return( 0 );
    }

    return( atoi( PQgetvalue( res_tmp, 0, 0 ) ) );
}

long size_monthDB()
{
    char z[1024];

    //         1  
    //   .
   if( !strcmp( month1(), today() ) )
   snprintf( z, sizeof(z)-1, "SELECT SUM(size) FROM %s WHERE " \
     "addr='%s' AND date = '%s'", sql->table_ftn, FTN_ADDR, today() );
   else
   snprintf( z, sizeof(z)-1, "SELECT SUM(size) FROM %s WHERE " \
     "addr='%s' AND date > '%s' AND date <= '%s'",
      sql->table_ftn, FTN_ADDR, month1(), today() );
    //  size   .
    res_tmp = PQexec( conn, z );
    if( PQresultStatus( res_tmp ) != PGRES_TUPLES_OK )
    {
	log( "SELECT * FROM command failed!" );
	PQclear( res_tmp );
	return( 0 );
    }

    return( atol( PQgetvalue( res_tmp, 0, 0 ) ) );
}

int file_monthDB()
{
    char z[1024];

    //         1  
    //   .
   if( !strcmp( month1(), today() ) )
    snprintf( z, sizeof(z)-1, "SELECT COUNT(size) FROM %s WHERE " \
     "addr='%s' AND date = '%s'", sql->table_ftn, FTN_ADDR, today() );
   else
     snprintf( z, sizeof(z)-1, "SELECT COUNT(size) FROM %s WHERE " \
     "addr='%s' AND date > '%s' AND date <= '%s'",
      sql->table_ftn, FTN_ADDR, month1(), today() );
    //  size   .
    res_tmp = PQexec( conn, z );
    if( PQresultStatus( res_tmp ) != PGRES_TUPLES_OK )
    {
	log( "SELECT * FROM command failed!" );
	PQclear( res_tmp );
	return( 0 );
    }

    return( atoi( PQgetvalue( res_tmp, 0, 0 ) ) );
}

long TotalSizeDB()
{
    char z[1024];

    //     .
    snprintf( z, sizeof(z)-1, "SELECT SUM(size) FROM %s WHERE " \
     "addr='%s'", sql->table_ftn, FTN_ADDR );
    //  size   .
    res_tmp = PQexec( conn, z );
    if( PQresultStatus( res_tmp ) != PGRES_TUPLES_OK )
    {
	log( "SELECT * FROM command failed!" );
	PQclear( res_tmp );
	return( 0 );
    }

    return( atol( PQgetvalue( res_tmp, 0, 0 ) ) );
}

int TotalFileDB()
{
    char z[1024];

    //   -  .
    snprintf( z, sizeof(z)-1, "SELECT COUNT(size) FROM %s WHERE " \
     "addr='%s'", sql->table_ftn, FTN_ADDR );
    //  size   .
    res_tmp = PQexec( conn, z );
    if( PQresultStatus( res_tmp ) != PGRES_TUPLES_OK )
    {
	log( "SELECT * FROM command failed!" );
	PQclear( res_tmp );
	return( 0 );
    }

    return( atoi( PQgetvalue( res_tmp, 0, 0 ) ) );
}

int insert_new_find();

/*        */
int FindDB()
{
    int nTuples, i, freqok;
    char file[CHAR_MAX], z[1024], tmp[CHAR_MAX], system, *filename;

    if( !( filename = validname( req->file ) ) )
    {
	log( "Error in filename = \"%s\"", req->file );
	return( -1 );
    }

    //   'z'  .
    snprintf( file, sizeof(file)-1, "%s", filename );
    i = 0;
    while( file[i] != 0 )
    {
	// TODO -   '\*'  '\?'
	if( file[i] == '*' ) file[i] = '%';
	if( file[i] == '?' ) file[i] = '_';
	if( ++i >= sizeof(file)-1 ) break;
    } 

    //     alias
    snprintf( z, sizeof(z)-1, "SELECT DISTINCT * FROM %s WHERE " \
     "alias LIKE '%s'", sql->table_freq, file );

    FIND = -1;	//     'FIND'.

    res = PQexec( conn, z );
    if( PQresultStatus( res ) != PGRES_TUPLES_OK )
    {
	log( "SELECT * FROM command failed!" );
	PQclear( res );
	return( -1 );
    }

    nTuples = PQntuples( res );

    for( i = 0; i < nTuples; i++ )
    {
	strcpy( find->alias, PQgetvalue( res, i, 0 ) );
	strcpy( find->file, PQgetvalue( res, i, 1 ) );
	strcpy( find->path, PQgetvalue( res, i, 2 ) );
	snprintf( tmp, sizeof(tmp)-1, "%s", PQgetvalue( res, i, 3 ) );
	find->system = tmp[0];
	strcpy( find->passwd, PQgetvalue( res, i, 4 ) );

	sizefile();

	//  NO_LIMIT = TRUE -   !
	if( ( limit->no_limit == FALSE ) &&
	 ( file_dayDB() >= limit->file_day ||		//   
	 file_weekDB() >= limit->file_week ||		//   
	 file_monthDB() >= limit->file_month ||	//   
	 NFILE >= limit->file_session ) )		//   .
	{
#ifdef	DEBUG
	    printf( "[%s] File: %s (%ld) - Files limit is exhausted\n",
	     FTN_ADDR, find->file, find->size );
#endif
	    log( "File: %s (%d) - Files limit is exhausted",
	     find->file, find->size );
	    //   REP_FILE      -.
	    rep_file( "%s (%db) - %s",
	     find->file, find->size, koi2alt( LIMIT_FILES ) );
	    FIND = 0;	//    0.
	}
	else
	{
	    //        !
	    if( strlen( find->passwd ) > 0 )
	    {
		if( req->passwd == NULL )
		{
		    log( "Freq '%s' file error - password (\"NULL\") error!",
	    	     find->file );
		    rep_file( "%s - %s", find->file, koi2alt( PASSWDERR ) );
		    FIND = 0;	//    0.
		}
		else if( req->passwd != NULL )
		    if( strcmp( find->passwd, req->passwd ) )
		    {
			log( "Freq '%s' file error - password (\"%s\") error!",
	    		 find->file, req->passwd );
			rep_file( "%s - %s", find->file, koi2alt( PASSWDERR ) );
			FIND = 0;	//    0.
		    }
		    else
		    {
		    	//       .
			if( insert_new_find() ) return( -1 );
		    }
	    }
	    else
	    {
		//  NO_LIMIT = TRUE -   !
		if( ( limit->no_limit == FALSE ) &&
		 ( find->size + size_dayDB() > limit->size_day ||
		 find->size + size_weekDB() > limit->size_week ||
		 find->size + size_monthDB() > limit->size_month ||
		 find->size + SIZE > limit->size_session ) )
		{
#ifdef	DEBUG
		    printf( "[%s] File: %s (%ld) - size limit is exhausted\n",
		     FTN_ADDR, find->file, find->size );
#endif	/* DEBUG */
		    log( "File: %s (%d) - size limit is exhausted",
		     find->file, find->size );
		    //   REP_FILE      .
		    rep_file( "%s (%db) - %s",
		     find->file, find->size, koi2alt( LIMIT_SIZE ) );
		    FIND = 0;	//    0.
		}
		else
		{
		    //    (system == 'a' || 'p' || 'l')
		    freqok = -1;
		    system = find->system;
		    switch( FTN_SYSTEM )
		    {
			case PROTECT:
			    freqok = 0;
			    break;
			case UNPROTECT:
			    if( system == 'p' )
				break;
			    else
				freqok = 0;
			    break;
			case LISTED:
			    if( system == 'p' )
				break;
			    else
				freqok = 0;
			    break;
			case ALL:
			    if( system == 'a' )
				freqok = 0;
			    break;
		    }

		    if( !freqok )
		    {
		    	//       .
			if( insert_new_find() ) return( -1 );
		    }
		    else
		    {
			log( "Freq file: \"%s\" (%db) - freq not allowed",
			 find->file, find->size );
			rep_file( "%s (%db) - %s",
			 find->file, find->size, koi2alt( NOTALLOWED ) );
			FIND = 0;	//    0.
		    }
		}
	    }
	}
    }

    return( nTuples );
}

//       .
int insert_new_find()
{
    char z[1024], *filename;

    if( !( filename = validname( find->file ) ) )
    {
	log( "Error in filename = \"%s\"", find->file );
	return( -1 );
    }

    //       .
    snprintf( z, sizeof(z)-1, "INSERT INTO %s " \
     "VALUES('%s', '%s', '%s/%s', %ld)", sql->table_ftn,
     FTN_ADDR, today(), find->path, filename,
     find->size );
    res_tmp = PQexec( conn, z );
    if( atoi( PQcmdTuples( res_tmp ) ) <= 0 ) return( -1 );
    log( "Freq file: \"%s\" from \"%s\" (%db) - Ok",
     find->file, find->path, find->size );
#ifdef	DESC
    rep_file( "%s (%db) - %s", find->file, find->size, read_desc() );
    //  ,   DESC_STR.
    free_desc();
#else	/* DESC */
    rep_file( "%s (%db) - Ok", find->file, find->size );
#endif	/* DESC */
    //   OUT_FILE      .
    out_file();
    NFILE++;
    SIZE += find->size;
    FIND = 0;	//    0.
    return( 0 );
}
#endif	/* PGSQL */
