#include <stdio.h>
#include <unistd.h>
#include "includes.h"
#ifdef	WIN32
#include <io.h>
#ifndef	SRIF
#define	SRIF
#endif	/* SRIF */
#endif	/* WIN32 */

FIND_TYPE *find;

int out_file()
{
    FILE *out_f;
    char str[PATH_MAX];

    if( !OUT_FILE )
    {
	log( "OUT_FILE == NULL!!!" );
	rep_file( "ERROR: Internal error at %s in %d!", __FILE__, __LINE__ );
	rep_file( "Please return this message (with kludges)..." );
	return( -1 );

    }
#ifndef	WIN32
    snprintf( str, sizeof(str)-1, "%s/%s", find->path, find->file );
#else
    snprintf( str, sizeof(str)-1, "%s\\%s", find->path, find->file );
#endif	/* WIN32 */
    if( access( str, F_OK ) )
    {
	log( "File \"%s\" don't exists!", str );
	return( 0 );
    }

    if( ( out_f = fopen( OUT_FILE, "a" ) ) == NULL )
    {
	log( "Can't create OUT_FILE \"%s\"!", OUT_FILE );
	return( -1 );
    }

#ifdef	SRIF
    if( !SRIF_FREQ )
#ifndef	WIN32
	fprintf( out_f, "+%s/%s\n", find->path, find->file );
#else
	fprintf( out_f, "+%s\\%s\n", find->path, find->file );
#endif	/* WIN32 */
    else
#endif	/* SRIF */
#ifndef	WIN32
	fprintf( out_f, "%s/%s %s\n", find->path, find->file, find->file );
#else
	fprintf( out_f, "%s\\%s %s\n", find->path, find->file, find->file );
#endif	/* WIN32 */

    fclose( out_f );
    return( 0 );
}

#ifdef	SRIF
int srif_out_file()
{
    FILE *out_f;
    char *rep_file;

    //     --- .
    if( REP_FILE == NULL ) return( 0 );

    if( ( out_f = fopen( OUT_FILE, "a" ) ) == NULL )
    {
	log( "Can't create OUT_FILE \"%s\"!", OUT_FILE );
	//  REP_FILE
	remove( REP_FILE );
	return( -1 );
    }

    //  pkt
    rep_file = report2pkt( REP_FILE );

    //  pkt   ,    REP_FILE

    if( rep_file != NULL )
    {
	log( "Send Response File \"%s\"", rep_file );
	fprintf( out_f, "=%s\n", rep_file );
    }
    else
    {
	log( "Send Response File \"%s\"!", REP_FILE );
	fprintf( out_f, "=%s\n", REP_FILE );
    }

    fclose( out_f );

    //  REP_FILE.    ,  pkt !
    if( rep_file != NULL ) remove( REP_FILE );

    return( 0 );
}
#endif	/* SRIF */
