#ifdef	WIN32
#ifndef	MYDB
#define	MYDB
#endif	/* MYDB */
#undef	PGSQL
#undef	MY_SQL
#undef	DESC
#endif	/* WIN32 */

#ifdef	MY_SQL

#include <stdio.h>
#include <string.h>
#include <stdlib.h>
#include "includes.h"

LIMIT_TYPE *limit;
REQ_TYPE *req;
SQL_TYPE *sql;
FIND_TYPE *find;

void exit_nicely(MYSQL *sock)
{
    if( res != NULL ) mysql_free_result( res );
    if( res_tmp != NULL ) mysql_free_result( res_tmp );
    mysql_close( sock );
}

int init_mysql()
{
    if( !sql->host || !sql->dbName || !sql->port )
    {
	    log( "Critical ERROR! Show HOST or DBNAME or PORT!" );
	    return( -1 );
    }

    mysql_init( &mysql );
    if( !( sock = mysql_real_connect( &mysql, sql->host,
	sql->user, sql->passwd, sql->dbName, atoi( sql->port ), NULL, 0 ) ) )
    {
	log( "Couldn't connect to engine! \"%s\"", mysql_error( &mysql ) );
#ifdef	DEBUG
	printf( "init_mysql() - connect to database failed...\n" );
#endif	/* DEBUG */
	return( -1 );
    }

#ifdef	DEBUG
    printf( "init_mysql() - connect Ok.\n" );
#endif	/* DEBUG */

    return( 0 );
}

long size_dayDB()
{
    char z[1024];

    //        .
    snprintf( z, sizeof(z)-1, "SELECT SUM(size) FROM %s WHERE " \
     "addr='%s' AND date='%s'", sql->table_ftn, FTN_ADDR, today() );
    //  size   .
    if( mysql_query( sock, z ) )
    {
	log( "Query failed (%s)", mysql_error( sock ) );
	return( -1 );
    }

    if( !( res = mysql_store_result( sock ) ) )
    {
	log( "Couldn't get result from query failed", mysql_error( sock ) );
	return( -1 );
    }

    row = mysql_fetch_row( res );
    snprintf( z, sizeof(z)-1, "%s", row[0] );
    return( atol( z ) );
}

int file_dayDB()
{
    char z[1024];

    //   -     .
    snprintf( z, sizeof(z)-1, "SELECT COUNT(size) FROM %s WHERE " \
     "addr='%s' AND date='%s'", sql->table_ftn, FTN_ADDR, today() );
    //  size   .
    if( mysql_query( sock, z ) )
    {
	log( "Query failed (%s)", mysql_error( sock ) );
	return( -1 );
    }

    if( !( res = mysql_store_result( sock ) ) )
    {
	log( "Couldn't get result from query failed", mysql_error( sock ) );
	return( -1 );
    }

    row = mysql_fetch_row( res );
    snprintf( z, sizeof(z)-1, "%s", row[0] );
    return( atoi( z ) );
}

long size_weekDB()
{
    char z[1024];

    //         
    //   .
    if( !strcmp( week(), today() ) )
    snprintf( z, sizeof(z)-1, "SELECT SUM(size) FROM %s WHERE " \
     "addr='%s' AND date = '%s'", sql->table_ftn, FTN_ADDR, today() );
    else
    snprintf( z, sizeof(z)-1, "SELECT SUM(size) FROM %s WHERE " \
     "addr='%s' AND date > '%s' AND date <= '%s'",
      sql->table_ftn, FTN_ADDR, week(), today() );
    //  size   .
    if( mysql_query( sock, z ) )
    {
	log( "Query failed (%s)", mysql_error( sock ) );
	return( -1 );
    }

    if( !( res = mysql_store_result( sock ) ) )
    {
	log( "Couldn't get result from query failed", mysql_error( sock ) );
	return( -1 );
    }

    row = mysql_fetch_row( res );
    snprintf( z, sizeof(z)-1, "%s", row[0] );
    return( atol( z ) );
}

int file_weekDB()
{
    char z[1024];

    //   -      
    //   .
    if( !strcmp( week(), today() ) )
    snprintf( z, sizeof(z)-1, "SELECT COUNT(size) FROM %s WHERE " \
     "addr='%s' AND date = '%s'", sql->table_ftn, FTN_ADDR, today() );
    else
    snprintf( z, sizeof(z)-1, "SELECT COUNT(size) FROM %s WHERE " \
     "addr='%s' AND date > '%s' AND date <= '%s'",
      sql->table_ftn, FTN_ADDR, week(), today() );
    //  size   .
    if( mysql_query( sock, z ) )
    {
	log( "Query failed (%s)", mysql_error( sock ) );
	return( -1 );
    }

    if( !( res = mysql_store_result( sock ) ) )
    {
	log( "Couldn't get result from query failed", mysql_error( sock ) );
	return( -1 );
    }

    row = mysql_fetch_row( res );
    snprintf( z, sizeof(z)-1, "%s", row[0] );
    return( atoi( z ) );
}

long size_monthDB()
{
    char z[1024];

    //         1  
    //   .
   if( !strcmp( month1(), today() ) )
   snprintf( z, sizeof(z)-1, "SELECT SUM(size) FROM %s WHERE " \
     "addr='%s' AND date = '%s'", sql->table_ftn, FTN_ADDR, today() );
   else
   snprintf( z, sizeof(z)-1, "SELECT SUM(size) FROM %s WHERE " \
     "addr='%s' AND date > '%s' AND date <= '%s'",
      sql->table_ftn, FTN_ADDR, month1(), today() );
    //  size   .
    if( mysql_query( sock, z ) )
    {
	log( "Query failed (%s)", mysql_error( sock ) );
	return( -1 );
    }

    if( !( res = mysql_store_result( sock ) ) )
    {
	log( "Couldn't get result from query failed", mysql_error( sock ) );
	return( -1 );
    }

    row = mysql_fetch_row( res );
    snprintf( z, sizeof(z)-1, "%s", row[0] );
    return( atol( z ) );
}

int file_monthDB()
{
    char z[1024];

    //         1  
    //   .
   if( !strcmp( month1(), today() ) )
    snprintf( z, sizeof(z)-1, "SELECT COUNT(size) FROM %s WHERE " \
     "addr='%s' AND date = '%s'", sql->table_ftn, FTN_ADDR, today() );
   else
     snprintf( z, sizeof(z)-1, "SELECT COUNT(size) FROM %s WHERE " \
     "addr='%s' AND date > '%s' AND date <= '%s'",
      sql->table_ftn, FTN_ADDR, month1(), today() );
    //  size   .
    if( mysql_query( sock, z ) )
    {
	log( "Query failed (%s)", mysql_error( sock ) );
	return( -1 );
    }

    if( !( res = mysql_store_result( sock ) ) )
    {
	log( "Couldn't get result from query failed", mysql_error( sock ) );
	return( -1 );
    }

    row = mysql_fetch_row( res );
    snprintf( z, sizeof(z)-1, "%s", row[0] );
    return( atoi( z ) );
}

long TotalSizeDB()
{
    char z[1024];

    //     .
    snprintf( z, sizeof(z)-1, "SELECT SUM(size) FROM %s WHERE " \
     "addr='%s'", sql->table_ftn, FTN_ADDR );
    //  size   .
    if( mysql_query( sock, z ) )
    {
	log( "Query failed (%s)", mysql_error( sock ) );
	return( -1 );
    }

    if( !( res = mysql_store_result( sock ) ) )
    {
	log( "Couldn't get result from query failed", mysql_error( sock ) );
	return( -1 );
    }

    row = mysql_fetch_row( res );
    snprintf( z, sizeof(z)-1, "%s", row[0] );
    return( atol( z ) );
}

int TotalFileDB()
{
    char z[1024];

    //   -  .
    snprintf( z, sizeof(z)-1, "SELECT COUNT(size) FROM %s WHERE " \
     "addr='%s'", sql->table_ftn, FTN_ADDR );
    //  size   .
    if( mysql_query( sock, z ) )
    {
	log( "Query failed (%s)", mysql_error( sock ) );
	return( -1 );
    }

    if( !( res = mysql_store_result( sock ) ) )
    {
	log( "Couldn't get result from query failed", mysql_error( sock ) );
	return( -1 );
    }

    row = mysql_fetch_row( res );
    snprintf( z, sizeof(z)-1, "%s", row[0] );
    return( atoi( z ) );
}

int insert_new_find();

/*        */
int FindDB()
{
    unsigned int num_fields = 0, i;
    int freqok;
    char file[CHAR_MAX], z[1024], tmp[CHAR_MAX], system, *filename;

    if( !( filename = validname( req->file ) ) )
    {
	log( "Error in filename = \"%s\"", req->file );
	return( -1 );
    }

    //   'file'  .
    snprintf( file, sizeof(file)-1, "%s", filename );
    i = 0;
    while( file[i] != 0 )
    {
	// TODO -   '\*'  '\?'
	if( file[i] == '*' ) file[i] = '%';
	if( file[i] == '?' ) file[i] = '_';
	if( ++i >= sizeof(file)-1 ) break;
    } 

    //     alias
    snprintf( z, sizeof(z)-1, "SELECT DISTINCT * FROM %s WHERE " \
     "alias LIKE '%s'", sql->table_freq, file );

    FIND = -1;	//     'FIND'.

    if( mysql_query( sock, z ) )
    {
	log( "Query failed (%s)", mysql_error( sock ) );
	return( -1 );
    }

    if( !( res = mysql_store_result( sock ) ) )
    {
	log( "Couldn't get result from query failed", mysql_error( sock ) );
	return( -1 );
    }

    while( ( row = mysql_fetch_row( res ) ) )
    {
	num_fields = mysql_num_fields( res );
	for( i = 0; i < num_fields; i++ )
	{
	    switch( i )
	    {
		case 0:
		    strcpy( find->alias, row[i] );
		    break;
		case 1:
		    strcpy( find->file, row[i] );
		    break;
		case 2:
		    strcpy( find->path, row[i] );
		    break;
		case 3:
		    snprintf( tmp, sizeof(tmp)-1, "%s", row[i] );
		    find->system = tmp[0];
		    break;
		case 4:
		    strcpy( find->passwd, row[i] );
		    break;
	    }
	}

	sizefile();

	//  NO_LIMIT = TRUE -   !
	if( ( limit->no_limit == FALSE ) &&
	 ( file_dayDB() >= limit->file_day ||		//   
	 file_weekDB() >= limit->file_week ||		//   
	 file_monthDB() >= limit->file_month ||	//   
	 NFILE >= limit->file_session ) )		//   .
	{
#ifdef	DEBUG
	    printf( "[%s] File: %s (%ld) - Files limit is exhausted\n",
	     FTN_ADDR, find->file, find->size );
#endif	/* DEBUG */
	    log( "File: %s (%d) - Files limit is exhausted",
	     find->file, find->size );
	    //   REP_FILE      -.
	    rep_file( "%s (%db) - %s",
	     find->file, find->size, koi2alt( LIMIT_FILES ) );
	    FIND = 0;	//    0.
	}
	else
	{
	    //        !
	    if( strlen( find->passwd ) > 0 )
	    {
		if( req->passwd == NULL )
		{
		    log( "Freq '%s' file error - password (\"NULL\") error!",
	    	     find->file );
		    rep_file( "%s - %s", find->file, koi2alt( PASSWDERR ) );
		    FIND = 0;	//    0.
		}
		else
		{
		    if( req->passwd != NULL )
			if( strcmp( find->passwd, req->passwd ) )
			{
			    log( "Freq '%s' file error - password (\"%s\") error!",
	    		     find->file, req->passwd );
			    rep_file( "%s - %s", find->file,
					    koi2alt( PASSWDERR ) );
			    FIND = 0;	//    0.
			}
			else
			{
			    //       .
			    if( insert_new_find() ) return( -1 );
			}
		}
	    }
	    else
	    {
		//  NO_LIMIT = TRUE -   !
		if( ( limit->no_limit == FALSE ) &&
		 ( find->size + size_dayDB() > limit->size_day ||
		 find->size + size_weekDB() > limit->size_week ||
		 find->size + size_monthDB() > limit->size_month ||
		 find->size + SIZE > limit->size_session ) )
		{
#ifdef	DEBUG
		    printf( "[%s] File: %s (%ld) - size limit is exhausted\n",
		     FTN_ADDR, find->file, find->size );
#endif	/* DEBUG */
		    log( "File: %s (%d) - size limit is exhausted",
		     find->file, find->size );
		    //   REP_FILE      .
		    rep_file( "%s (%db) - %s",
		     find->file, find->size, koi2alt( LIMIT_SIZE ) );
		    FIND = 0;	//    0.
		}
		else
		{
		    //    (system == 'a' || 'p' || 'l')
		    freqok = -1;
		    system = find->system;
		    switch( FTN_SYSTEM )
		    {
			case PROTECT:
			    freqok = 0;
			    break;
			case UNPROTECT:
			    if( system == 'p' )
				break;
			    else
				freqok = 0;
			    break;
			case LISTED:
			    if( system == 'p' )
				break;
			    else
				freqok = 0;
			    break;
			case ALL:
			    if( system == 'a' )
				freqok = 0;
			    break;
		    }

		    if( !freqok )
		    {
		    	//       .
			if( insert_new_find() ) return( -1 );
		    }
		    else
		    {
			log( "Freq file: \"%s\" (%db) - freq not allowed",
			 find->file, find->size );
			rep_file( "%s (%db) - %s",
			 find->file, find->size, koi2alt( NOTALLOWED ) );
			FIND = 0;	//    0.
		    }
		}
	    }
	}
    }

    return( 1 ); // - .
}

//       .
int insert_new_find()
{
    char z[1024], *filename;

    if( !( filename = validname( find->file ) ) )
    {
	log( "Error in filename = \"%s\"", find->file );
	return( -1 );
    }

    //       .
    snprintf( z, sizeof(z)-1, "INSERT INTO %s " \
     "VALUES('%s', '%s', '%s/%s', %ld)", sql->table_ftn,
     FTN_ADDR, today(), find->path, filename,
     find->size );
    if( mysql_query( sock, z ) )
    {
	log( "Query failed (%s)", mysql_error( sock ) );
	return( -1 );
    }
    log( "Freq file: \"%s\" from \"%s\" (%db) - Ok",
     find->file, find->path, find->size );
#ifdef	DESC
    rep_file( "%s (%db) - %s", find->file, find->size, read_desc() );
    //  ,   DESC_STR.
    free_desc();
#else	/* DESC */
    rep_file( "%s (%db) - Ok", find->file, find->size );
#endif	/* DESC */
    //   OUT_FILE      .
    out_file();
    NFILE++;
    SIZE += find->size;
    FIND = 0;	//    0.
    return( 0 );
}

#endif	/* MY_SQL */
