#ifdef	WIN32
#ifndef	MYDB
#define	MYDB
#endif	/* MYDB */
#undef	PGSQL
#undef	MY_SQL
#undef	DESC
#endif	/* WIN32 */

#ifdef	MYDB

#include <stdio.h>
#include <string.h>
#include <stdlib.h>
#include "includes.h"

LIMIT_TYPE *limit;
REQ_TYPE *req;
FIND_TYPE *find;

//  strdate1  strdate2
int cmpdate(char *strdate1, char *strdate2)
{
	int d1, m1, y1;
	int d2, m2, y2;

	if( !strcmp( strdate1, strdate2 ) )
	{
#ifdef	DEBUG
	printf( "strdate1: (%s) == ", strdate1 );
	printf( "strdate2: (%s)\n", strdate2 );
#endif	/* DEBUG */
		return( 0 );
	}

	sscanf( strdate1, "%d/%d/%d", &d1, &m1, &y1 );
	sscanf( strdate2, "%d/%d/%d", &d2, &m2, &y2 );

	if( d1 <= d2 && m1 <= m2 && y1 <= y2 )
	{
#ifdef	DEBUG
		printf( "strdate1: (%d/%d/%d) <= ", d1, m1, y1 );
		printf( "strdate2: (%d/%d/%d)\n", d2, m2, y2 );
#endif	/* DEBUG */
		return( 0 );
	}

#ifdef	DEBUG
	printf( "strdate1: (%d/%d/%d) >= ", d1, m1, y1 );
	printf( "strdate2: (%d/%d/%d)\n", d2, m2, y2 );
#endif	/* DEBUG */

	return( -1 );
}

long size_dayDB()
{
	int i = 0;
	long size = 0;
	char *date;

	//   .
	date = today();
	while( 1 )
	{
		//    -1 --- .
		if( read_ftn_idx( i++ ) ) break;
		if( !strcmp( FTN_ADDR, FTN_TABLE.addr ) &&
			!strcmp( date, FTN_TABLE.date ) )
			size += FTN_TABLE.size;
	}
	return( size );
}

int file_dayDB()
{
	int i = 0, num = 0;
	char *date;

	//   .
	date = today();
	while( 1 )
	{
		//    -1 --- .
		if( read_ftn_idx( i++ ) ) break;
		if( !strcmp( FTN_ADDR, FTN_TABLE.addr ) &&
			!strcmp( date, FTN_TABLE.date ) ) num++;
	}
	return( num );
}

long size_weekDB()
{
	int i = 0;
	long size = 0;

	while( 1 )
	{
		//    -1 --- .
		if( read_ftn_idx( i++ ) ) break;
		if( !strcmp( FTN_ADDR, FTN_TABLE.addr ) &&
			// week() <= FTN_TABLE.date
			( !cmpdate( week(), FTN_TABLE.date ) &&
			// FTN_TABLE <= today()
			  !cmpdate( FTN_TABLE.date, today() ) ) )
			size += FTN_TABLE.size;
	}
	return( size );
}

int file_weekDB()
{
	int i = 0, num = 0;

	while( 1 )
	{
		//    -1 --- .
		if( read_ftn_idx( i++ ) ) break;
		if( !strcmp( FTN_ADDR, FTN_TABLE.addr ) &&
			// week() <= FTN_TABLE.date
			( !cmpdate( week(), FTN_TABLE.date ) &&
			// FTN_TABLE.date <= today()
			  !cmpdate( FTN_TABLE.date, today() ) ) ) num++;
	}
	return( num );
}

long size_monthDB()
{
	int i = 0;
	long size = 0;

	while( 1 )
	{
		//    -1 --- .
		if( read_ftn_idx( i++ ) ) break;
		if( !strcmp( FTN_ADDR, FTN_TABLE.addr ) &&
			// month1() <= FTN_TABLE.date
			( !cmpdate( month1(), FTN_TABLE.date ) &&
			// FTN_TABLE <= today()
			  !cmpdate( FTN_TABLE.date, today() ) ) )
			size += FTN_TABLE.size;
	}
	return( size );
}

int file_monthDB()
{
	int i = 0, num = 0;

	while( 1 )
	{
		//    -1 --- .
		if( read_ftn_idx( i++ ) ) break;
		if( !strcmp( FTN_ADDR, FTN_TABLE.addr ) &&
			// month1() <= FTN_TABLE.date
			( !cmpdate( month1(), FTN_TABLE.date ) &&
			// FTN_TABLE <= today()
			  !cmpdate( FTN_TABLE.date, today() ) ) ) num++;
	}
	return( num );
}

long TotalSizeDB()
{
	int i = 0;
	long size = 0;
	char *date;

	//   .
	date = today();
	while( 1 )
	{
		//    -1 --- .
		if( read_ftn_idx( i++ ) ) break;
		if( !strcmp( FTN_ADDR, FTN_TABLE.addr ) )
			size += FTN_TABLE.size;
	}
	return( size );
}

int TotalFileDB()
{
	int i = 0, num = 0;
	char *date;

	//   .
	date = today();
	while( 1 )
	{
		//    -1 --- .
		if( read_ftn_idx( i++ ) ) break;
		if( !strcmp( FTN_ADDR, FTN_TABLE.addr ) ) num++;
	}
	return( num );
}

int insert_new_find();

/*        */
int FindDB()
{
	unsigned int i;
	int freqok;
	char file[CHAR_MAX], system;

	//   'file'  .
	snprintf( file, sizeof(file)-1, "%s", req->file );

	FIND = -1;	//     'FIND'.

	i = 0;
	while( 1 )
	{
		//    -1 --- .
		if( read_freq_idx( i++ ) ) return( 0 );
#ifdef	WIN32
		//  Win32       !
		strcpy( FREQ_TABLE.alias, strlwr( FREQ_TABLE.alias ) );
#endif	/* WIN32 */
		if( wildmat( FREQ_TABLE.alias, file ) == TRUE )
		{
			strcpy( find->alias, FREQ_TABLE.alias );
			strcpy( find->file, FREQ_TABLE.file );
			strcpy( find->path, FREQ_TABLE.path );
			find->system = FREQ_TABLE.system;
			strcpy( find->passwd, FREQ_TABLE.passwd );
			break;
		}
	}

	sizefile();

	//  NO_LIMIT = TRUE -   !
	if( ( limit->no_limit == FALSE ) &&
	 ( file_dayDB() >= limit->file_day ||		//   
	 file_weekDB() >= limit->file_week ||		//   
	 file_monthDB() >= limit->file_month ||	//   
	 NFILE >= limit->file_session ) )		//   .
	{
#ifdef	DEBUG
	    printf( "[%s] File: %s (%ld) - Files limit is exhausted\n",
	     FTN_ADDR, find->file, find->size );
#endif	/* DEBUG */
	    log( "File: %s (%d) - Files limit is exhausted",
	     find->file, find->size );
	    //   REP_FILE      -.
	    rep_file( "%s (%db) - %s",
	     find->file, find->size, koi2alt( LIMIT_FILES ) );
	    FIND = 0;	//    0.
	}
	else
	{
	    //        !
	    if( strlen( find->passwd ) > 0 )
	    {
		if( req->passwd == NULL )
		{
		    log( "Freq '%s' file error - password (\"NULL\") error!",
	    	     find->file );
		    rep_file( "%s - %s", find->file, koi2alt( PASSWDERR ) );
		    FIND = 0;	//    0.
		}
		else
		{
		    if( req->passwd != NULL )
		    {
			if( strcmp( find->passwd, req->passwd ) )
			{
			    log( "Freq '%s' file error - password (\"%s\") error!",
	    		     find->file, req->passwd );
			    rep_file( "%s - %s", find->file,
					    koi2alt( PASSWDERR ) );
			    FIND = 0;	//    0.
			}
			else
			{
			    //       .
			    if( insert_new_find() ) return( -1 );
			}
		    }
		}
	    }
	    else
	    {
		//  NO_LIMIT = TRUE -   !
		if( ( limit->no_limit == FALSE ) &&
		 ( find->size + size_dayDB() > limit->size_day ||
		 find->size + size_weekDB() > limit->size_week ||
		 find->size + size_monthDB() > limit->size_month ||
		 find->size + SIZE > limit->size_session ) )
		{
#ifdef	DEBUG
		    printf( "[%s] File: %s (%ld) - size limit is exhausted\n",
		     FTN_ADDR, find->file, find->size );
#endif	/* DEBUG */
		    log( "File: %s (%d) - size limit is exhausted",
		     find->file, find->size );
		    //   REP_FILE      .
		    rep_file( "%s (%db) - %s",
		     find->file, find->size, koi2alt( LIMIT_SIZE ) );
		    FIND = 0;	//    0.
		}
		else
		{
		    //    (system == 'a' || 'p' || 'l')
		    freqok = -1;
		    system = find->system;
		    switch( FTN_SYSTEM )
		    {
			case PROTECT:
			    freqok = 0;
			    break;
			case UNPROTECT:
			    if( system == 'p' )
				break;
			    else
				freqok = 0;
			    break;
			case LISTED:
			    if( system == 'p' )
				break;
			    else
				freqok = 0;
			    break;
			case ALL:
			    if( system == 'a' )
				freqok = 0;
			    break;
		    }

		    if( !freqok )
		    {
		    	//       .
			if( insert_new_find() ) return( -1 );
		    }
		    else
		    {
			log( "Freq file: \"%s\" (%db) - freq not allowed",
			 find->file, find->size );
			rep_file( "%s (%db) - %s",
			 find->file, find->size, koi2alt( NOTALLOWED ) );
			FIND = 0;	//    0.
		    }
		}
	    }
	}

	return( 1 ); // - .
}

//       .
int insert_new_find()
{
	char file[512];

	//     .
#ifndef	WIN32
	snprintf( file, sizeof(file)-1, "%s/%s", find->path, find->file );
#else
	snprintf( file, sizeof(file)-1, "%s\\%s", find->path, find->file );
#endif	/* WIN32 */
	//  .
	strcpy( FTN_TABLE.addr, FTN_ADDR );
	strcpy( FTN_TABLE.date, today() );
	strcpy( FTN_TABLE.file, file );
	FTN_TABLE.size = find->size;

	//   idx -.
	if( write_ftn_idx() )
	{
		log( "Error! write_ftn_idx() return -1" );
		return( -1 );
	}

	log( "Freq file: \"%s\" from \"%s\" (%db) - Ok",
			find->file, find->path, find->size );
#ifdef	DESC
	rep_file( "%s (%db) - %s", find->file, find->size, read_desc() );
	//  ,   DESC_STR.
	free_desc();
#else	/* DESC */
	rep_file( "%s (%db) - Ok", find->file, find->size );
#endif	/* DESC */
	//   OUT_FILE      .
	out_file();
	NFILE++;
	SIZE += find->size;
	FIND = 0;	//    0.
	return( 0 );
}

#endif	/* MYDB */
