#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <locale.h>
#include <time.h>
#include "includes.h"

#ifdef	WIN32
#include <process.h>
#ifndef	MYDB
#define	MYDB
#endif	/* MYDB */
#ifndef	SRIF
#define	SRIF
#endif	/* SRIF */
#undef	PGSQL
#undef	MY_SQL
#undef	DESC
#endif	/* WIN32 */


#ifdef	SRIF
#include <unistd.h>
#include "srif.h"
#endif	/* SRIF */

/*
	tmafreq [-e[a][l][p]] [-wazoo|-bark] [-p|-l] [-s<SPEED>] <ftn_address> <req_file> <out_file> <rep_file>
    or
	tmafreq-srif /path/srif_file
 */

LIMIT_TYPE *limit;
REQ_TYPE *req;

#if defined(PGSQL) || defined(MY_SQL)
SQL_TYPE *sql;
#endif	/* PGSQL || MY_SQL */

#ifdef	PGSQL
PGconn *conn;
#endif	/* PGSQL */

#ifdef	MY_SQL
MYSQL mysql,*sock;
MYSQL *sock;
MYSQL_RES *res;
#endif	/* MY_SQL */

GLOBAL_TYPE *gl;
FIND_TYPE *find;

#ifdef	SRIF
char srif_rep_file[CHAR_MAX];
#endif	/* SRIF */

int main(int argc, char *argv[])
{
    int flag = 0;
    int i, t;
#ifdef	QICOBUG
    FILE *out_f;
#endif	/* QICOBUG */
    char *name, tmp[CHAR_MAX];

    /* ------------------------  -------------------------- */
    //  .
    timer_init();

#ifndef	WIN32
    setlocale( LC_TIME, "" );
#endif	/* WIN32 */

    week();

    // default
    MAXTIME = -1; // default --- nolimit;

    name = basename( argv[0] );
    /* ----------------------------------------------------------------- */

#ifndef	WIN32
    if( !strcmp( name, "tmafreq-srif" ) )
    {
#ifdef	SRIF
	    SRIF_FREQ = 0;
	    strcpy( CRLF, "\r\n" );
#ifdef	DEBUG
	    printf( "Use as SRIF freq processor\n" );
#endif	/* DEBUG */
#else
	    fprintf( stderr, "Error! SRIF not supported!\n" );
	    log( "Error! SRIF not supported!" );
	    SRIF_FREQ = -1;
#endif	/* SRIF */
    }
    else
    {
	    SRIF_FREQ = -1;
	    strcpy( CRLF, "\n" );
    }
#endif	/* WIN32 */
#ifdef	WIN32
    SRIF_FREQ = 0;
    strcpy( CRLF, "\n" );
#ifdef	DEBUG
	printf( "Use as SRIF freq processor\n" );
#endif	/* DEBUG */
#endif	/* WIN32 */

#ifdef	DEBUG
    printf( "SRIF_FREQ = \"%s\"\n", SRIF_FREQ ? "NO" : "YES" );
#endif	/* DEBUG */

#ifdef	SRIF
    if( SRIF_FREQ )
    {
#endif	/* SRIF */
	//    freq -.
	if( argc < 5 )
	{
	    printf( "Error! Use: \"%s [-e[a][l][p]] [-wazoo|-bark] [-p|-l]" \
	     " [-s<SPEED>] <ftn_address> <req_file> <out_file> <rep_file>\"\n",
	     name );
	    return( -1 );
	}

	FTN_ADDR = argv[argc-4];
	REQ_FILE = argv[argc-3];
	OUT_FILE = argv[argc-2];
	REP_FILE = argv[argc-1];

	METOD = NO_METOD;
	FTN_SYSTEM = ALL;
	SPEED = 0;
	RSYSOP = strdup( "SysOp" );
#ifdef	SRIF
    }
    else
    {
	//   srif - freq -.
	if( argc < 2 )
	{
#ifndef	WIN32
	    printf( "Error! Use: \"%s /path/srif_file\"\n", name );
#else
	    printf( "Error! Use: \"%s C:\\PATH\\SRIF_FILE\"\n", name );
#endif	/* WIN32 */
	    return( -1 );
	}

	if( srif_main( argv[1] ) )	//  SRIF .
	    return( -1 );

	FTN_ADDR = SRIF_AKA;
	REQ_FILE = SRIF_REQ;
	OUT_FILE = SRIF_OUT;
#ifndef	WIN32
	snprintf( srif_rep_file, sizeof(srif_rep_file)-1, "/tmp/srifrep%d.tmp",
			getpid() );
#else
	sprintf( srif_rep_file, "%s%8d.TMP", TEMP, getpid() );
#endif	/* WIN32 */
	REP_FILE = srif_rep_file;

	METOD = NO_METOD;
	FTN_SYSTEM = SRIF_SYSTEM;
	SPEED = SRIF_BAUD;
    }
#endif	/* SRIF */

    //  .
    limit = calloc( 1, sizeof( struct limit_type ) );
    req = calloc( 1, sizeof( struct req_type ) );
    req->file = NULL;
    req->passwd = NULL;
    req->ttt = NULL;
#if defined(PGSQL) || defined(MY_SQL)
    sql = calloc( 1, sizeof( struct sql_type ) );
#endif	/* PGSQL || MY_SQL */
    gl = calloc( 1, sizeof( struct global_type ) );
    find = calloc( 1, sizeof( struct find_type ) );

#ifdef	DEBUG
    printf( "\nargc       = %d\n", argc );
#endif	/* DEBUG */

#ifdef	SRIF
    if( SRIF_FREQ )
    {
#endif	/* SRIF */
	i = argc - 5;
	while( i > 0 )
	{
#ifdef	DEBUG
	    printf( "argv[%d]    = %s\n", i, argv[i] );
#endif	/* DEBUG */
	    if( !strcmp( argv[i], "-wazoo" ) )
		METOD = WAZOO;
	    else if( !strcmp( argv[i], "-bark" ) )
		METOD = BARK;
	    else if( !strcmp( argv[i], "-p" ) )
		FTN_SYSTEM = PROTECT;
	    else if( !strcmp( argv[i], "-l" ) )
		FTN_SYSTEM = LISTED;
	    //  qico   ?     ... ;)
	    else if( !strcmp( argv[i], "-a" ) )
		FTN_SYSTEM = ALL;
	    else if( !strncmp( argv[i], "-s", 2 ) )
		SPEED = atoi( argv[i]+2 );
//	    else if( !strcmp( argv[i], "-e" ) );
	    i--;
#ifdef	SRIF
	}
#endif	/* SRIF */

#ifdef	DEBUG
	printf( "FTN_ADDR   = %s\n", FTN_ADDR );
	printf( "REQ_FILE   = %s\n", REQ_FILE );
	printf( "OUT_FILE   = %s\n", OUT_FILE );
	if( SRIF_FREQ ) printf( "REP_FILE   = %s\n", REP_FILE );
	printf( "METOD      = %d\n", METOD );
	printf( "FTN_SYSTEM = %d\n", FTN_SYSTEM );
	printf( "SPEED      = %d\n", SPEED );
#endif	/* DEBUG */
    }

#ifdef	QICOBUG
    //    qico-0.45pl1   ,  OUT_FILE
    //          !
    if( ( out_f = fopen( OUT_FILE, "w" ) ) == NULL )
    {
	log( "Can't create OUT_FILE \"%s\"!", OUT_FILE );
	return( -1 );
    }
    fclose( out_f );
#else
    //    OUT_FILE
    remove( OUT_FILE );
#endif	/* QICOBUG */

    //  .
    readcfg( -1 );

    /* ----------------------------------------------------------------- */
    //   !
#ifdef	SRIF
    if( !SRIF_FREQ ) setenv( "SRIF", "YES", 1 );
    else setenv( "SRIF", "NO", 1 );
#else
    setenv( "SRIF", "NO", 1 );
#endif	/* SRIF */
    setenv( "FTN_ADDR", FTN_ADDR, 1 );
    setenv( "REQ_FILE", REQ_FILE, 1 );
    setenv( "OUT_FILE", OUT_FILE, 1 );
    setenv( "REP_FILE", REP_FILE, 1 );
    snprintf( tmp, sizeof(tmp)-1, "%d", METOD );
    setenv( "METOD", tmp, 1 );
    snprintf( tmp, sizeof(tmp)-1, "%d", FTN_SYSTEM );
    setenv( "FTN_SYSTEM", tmp, 1 );
    snprintf( tmp, sizeof(tmp)-1, "%d", SPEED );
    setenv( "FREQ_SPEED", tmp, 1 );
    setenv( "FREQSYSOP", RSYSOP, 1 );
    setenv( "SYSOP", SYSOP, 1 );
    /* ----------------------------------------------------------------- */


    //    REP_FILE
    remove( REP_FILE );

    //   .
    rep_begin();

#ifdef	PGSQL
    if( init_pgsql() )
    {
	rep_file( "ERROR: Internal error at %s in %d!",
			    __FILE__, __LINE__ );
	rep_file( "Please return this message (with kludges)..." );

	free( limit );
	free( req );
	free( sql );
	free( find );
	exit_nicely( conn );

#ifdef	SRIF
	if( !SRIF_FREQ )
	{
		remove( REQ_FILE );
		srif_out_file();
	}
#endif	/* SRIF */

	return( -1 );
    }
#endif	/* PGSQL */

#ifdef	MY_SQL
    if( init_mysql() )
    {
	rep_file( "ERROR: Internal error at %s in %d!", __FILE__, __LINE__ );
	rep_file( "Please return this message (with kludges)..." );

	free( limit );
	free( req );
	free( sql );
	free( find );
	exit_nicely( sock );

#ifdef	SRIF
	if( !SRIF_FREQ )
	{
		remove( REQ_FILE );
		srif_out_file();
	}
#endif	/* SRIF */

	return( -1 );
    }
#endif	/* MY_SQL */

    //   !
    t = ftimestr( limit->timestr );

    //   .
    if( limit->no_limit == FALSE )
    {
	if( limit->lower_speed != 0 && limit->lower_speed > SPEED )
	{
#ifdef	DEBUG
	    printf( "Warning! SPEED is too lower (%d/%d)\n",
		SPEED, limit->lower_speed );
#endif	/* DEBUG */
	    log( "Warning! SPEED is too lower (%d/%d)",
		SPEED, limit->lower_speed );
	    //     .
	    rep_file( "Warning! SPEED is too lower (%d/%d)",
		SPEED, limit->lower_speed );
	    flag = -1;
	}

	if( t == -1 )
	{
#ifdef	DEBUG
	    printf( "Warning! Time not allowed (%d/%s)\n", t, limit->timestr );
#endif	/* DEBUG */
	    log( "Warning! Time not allowed (%d/%s)", t, limit->timestr );
	    //     .
	    rep_file( "Warning! Time not allowed (%s)", limit->timestr );
	    flag = -1;
	}
#ifdef	DEBUG
	else
	    printf( "Time string: \"%s\", ftimestr() return = %d\n",
		limit->timestr, t );
#endif	/* DEBUG */
    }

    //  ---      .
    //  -1 ---  .
//    if( MAXTIME != -1 )
//    {
//	if( t != -1 && t != 0 )
//	{
//#ifdef	DEBUG
//	    printf( "Warning! Time not allowed (%d/%d)\n", t, MAXTIME );
//#endif	/* DEBUG */
//	    log( "Warning! Time not allowed (%d/%d)", t, MAXTIME );
//			//     .
//	    rep_file( "Warning! Time not allowed (%d/%d)", t, MAXTIME );
//	    flag = -1;
//	}
//    }

#ifdef	SRIF
    if( !SRIF_FREQ && ( !flag && limit->callerid != NULL ) )
    {
	if( wildmat( CALLER_ID, limit->callerid ) == FALSE )
	{
#ifdef	DEBUG
	    printf( "Warning! CallerID \"%s\"(config) != \"%s\"(system), error!\n",
		limit->callerid, CALLER_ID );
#endif	/* DEBUG */
	    log( "Warning! CallerID \"%s\"(config) != \"%s\"(system), error!",
		limit->callerid, CALLER_ID );
	//  .
	    rep_file( "Your system is not allowed to freq files here!" );
	    rep_file( "CallerID error!" );
	    flag = -1;
	}
    }
#endif	/* SRIF */

    if( !flag && req_file() )
    {
	//  REQ_FILE
	rep_file( "ERROR: Internal error at %s in %d!", __FILE__, __LINE__ );
	rep_file( "Please return this message (with kludges)..." );

	free( limit );
	free( req );
#ifdef	PGSQL
	free( sql );
	exit_nicely( conn );
#endif	/* PGSQL */
#ifdef	MY_SQL
	free( sql );
	exit_nicely( sock );
#endif	/* MY_SQL */
	free( find );

#ifdef	SRIF
	if( !SRIF_FREQ )
	{
		remove( REQ_FILE );
		srif_out_file();
	}
#endif	/* SRIF */

	return( -1 );
    }

    rep_end();

    //  
    free( limit );
    free( req );
#ifdef	PGSQL
    free( sql );
    exit_nicely( conn );
#endif	/* PGSQL */
#ifdef	MY_SQL
    free( sql );
    exit_nicely( sock );
#endif	/* MY_SQL */
    free( find );

#ifdef	SRIF
    if( !SRIF_FREQ )
    {
	    remove( REQ_FILE );
	    srif_out_file();
    }
#endif	/* SRIF */

    return( 0 );
}
