/************************************************************************/
/*		   (log -)			*/
/************************************************************************/
#include <stdio.h>
#include <stdarg.h>
#include <string.h>
#include <stdlib.h>
#include <unistd.h>
#include "includes.h"
#ifdef	WIN32
#include <process.h>
#endif	/* WIN32 */

#define	SHOW(s) fputs(s,logfile), cnt+=strlen(s)

int log(const char *format, ...)
{
	FILE *logfile;
	char *tokp, ifmt[CHAR_MAX], *hdr = ifmt, buf[CHAR_MAX];
	int cnt=0;
	va_list pa;

	strcpy( ifmt, format );	//    
	va_start( pa, format );	// pa -     

	//  log -.
	if( LogLock() ) return( -1 );	// Unknown error!

	if( ( logfile = fopen( LOGFILE, "a" ) ) == NULL ) return( -1 );

	if( !SRIF_FREQ )
	{
	    if( !FTN_ADDR )
		fprintf( logfile, "%s tmafreq-srif[%d] [0:0/0.0]: ",
		 timenow(), getpid() );
	    else
		fprintf( logfile, "%s tmafreq-srif[%d] [%s]: ",
		 timenow(), getpid(), FTN_ADDR );
	}
	else
	    fprintf( logfile, "%s tmafreq[%d] [%s]: ",
	     timenow(), getpid(), FTN_ADDR );

	while( ( tokp = strchr( hdr, '%' ) ) ) {/*   "%" */
		*tokp++ = '\0';
		SHOW(hdr);		//    "%"
		if( strchr( "dufgeisc%", *tokp ) ) { /* ,  
						    
						    */
			switch( *tokp ) {
				case 'd':	// %d &
				case 'u':	// %u &
				case 'i':	// %i
					snprintf(buf,sizeof(buf)-1,"%i",
							va_arg(pa,int));
					break;
				case 's':	// %s
					strcpy(buf,va_arg(pa,char*));
					break;
				case 'c':	// %c
					buf[0] = va_arg(pa,char);
					buf[1] = '\0';
					break;
				case 'f':	// %f
					snprintf(buf,sizeof(buf)-1,"%f",
							va_arg(pa,double));
					break;
				case 'g':	// %g
					snprintf(buf,sizeof(buf)-1,"%g",
							va_arg(pa,double));
					break;
				case '%':	// %%
					strcpy(buf,"%");
					break;
			}
			SHOW( buf );	//   
		}
		else {				/*   . -
						        */
			fputc( *tokp, logfile );
			cnt++;
		}
		hdr = tokp + 1;
	}
	SHOW( hdr );		// ,   ,  
	va_end( pa );

	fprintf( logfile, "\n" );
	fclose( logfile );

	//   log -.
	if( LogUnLock() ) return( -1 );	// Unknown error!

	return( 0 );
}
