#include <stdio.h>
#include <string.h>
#include <malloc.h>
#include "includes.h"

REQ_TYPE *req;
LIMIT_TYPE *limit;
GLOBAL_TYPE *gl;
FIND_TYPE *find;

int findok(char*, char*, char**);
int FindREQEXEC();
char execfile[PATH_MAX];
char rreq[CHAR_MAX];

#ifdef	WIN32
#ifndef	MYDB
#define	MYDB
#endif	/* MYDB */
#endif	/* WIN32 */

void FindReqFile()
{
    char s[CHAR_MAX];

    if( limit->protect == TRUE )
    {
	if( FTN_SYSTEM != PROTECT || FTN_SYSTEM_ST != PROTECT )
	{
	    log("Freq file: \"%s\" - freq not allowed (protected system only!)",
		req->file );
	    rep_file( "%s - %s", req->file, koi2alt( NOTALLOWED ) );
	    return;
	}
    }

    //    REQ,   ...
    if( FindREQEXEC() )
    {
#if defined(PGSQL) || defined(MY_SQL)
	if( FindDB() <= 0 )
	{
	    strcpy( s, req->file );
	    strcpy( req->file, strlwr( s ) );
	    FindDB();
	}
#endif	/* PGSQL || MY_SQL */
#if defined(MYDB) && !defined(WIN32)
	if( FindDB() <= 0 )
	{
	    strcpy( s, req->file );
	    strcpy( req->file, strlwr( s ) );
	    FindDB();
	}
#endif	/* MYDB */
#ifdef	WIN32
	//  Win32    .
	strcpy( s, req->file );
	strcpy( req->file, strlwr( s ) );
	FindDB();
#endif	/* MYDB */
    }

    if( FIND )
    {
	rep_file( "%s - %s", req->file, koi2alt( NOTFOUND ) );
	log( "Freq file: \"%s\" - Not found", req->file );
    }
}

int execreqok(char *file, char *str)
{
    int i = 0;
    char tmp[CHAR_MAX], *freq="\0", *newstr, *tok;

#ifdef	DEBUG
    printf( "str: \"%s\"\n", str );
#endif	/* DEBUG */

    strcpy( tmp, str );

    newstr = tmp;
    for( ; (char*)(tok = strtok( newstr, "," )); newstr = 0 )
    {
	//       ','.
	//  :  "<freq>, <exec programm> [, <file>]"
	switch( i )
	{
	    case 0:
		freq = tok;
#ifdef	DEBUG
		printf( "freq = \"%s\"", tok );
#endif	/* DEBUG */
		break;
	    case 1:
		strcpy( execfile, tok );
#ifdef	DEBUG
		printf( ", execfile = \"%s\"", execfile );
#endif	/* DEBUG */
		break;
	    case 2:
		strcpy( rreq, tok );
#ifdef	DEBUG
		printf( ", rreq = \"%s\"", rreq );
#endif	/* DEBUG */
		break;
	}
	i++;
    }
#ifdef	DEBUG
    printf( "\nfile = \"%s\", freq = \"%s\"\n", file, freq );
#endif	/* DEBUG */

    if( i >= 2 && !strcasecmp( file, freq ) )
    {
#ifdef	DEBUG
	printf( "strcasecmp() return 0\n" );
#endif	/* DEBUG */
	return( 0 );
    }
    return( -1 );
}

int exec_param(char *execstr, char **exec)
{
    int i;
    char *newstr, *tok, *newfreq;

    exec[0] = NULL;

    newfreq = strchr( execstr, ':' );
    if( !newfreq ) return( 0 );
    *newfreq = 0;
    ++newfreq;

    newstr = newfreq; i = 0;
    for( ; (char*)(tok = strtok( newstr, ":" )); newstr = 0 )
    {
	exec[i++] = strdup( skip_all_spaces( tok ) );
#ifdef	DEBUG
	printf( "exec[%d] = \"%s\"\n", i-1, exec[i-1] );
#endif	/* DEBUG */
	if( i >= 255 )
	{
	    *exec[255] = 0;
	    return( -1 );
	}
    }

    exec[i] = NULL;
    return( 0 );
}

int FindREQEXEC()
{
    char *param[255];
    //    "" ...
    if( limit->reqexecbool == FALSE ) return( -1 );

#ifdef	DEBUG
    printf( "ExecFreq file: \"%s\"\n", req->file );
    printf( "REQ_EXEC = \"%d\"\n", REQ_EXEC );
#endif	/* DEBUG */

    // "" .
    if( exec_param( req->file, param ) )
	log( "Warning: exec_param() return -1!" );

    if( gl->execreq[REQ_EXEC] != NULL )
    {
	for( execreq = gl->execreq[REQ_EXEC]; execreq != NULL;
			execreq = execreq->next )
	{
	    //   .
	    strcpy( execfile, "\0" );
	    strcpy( rreq, "\0" );
	    if( !execreqok( req->file, execreq->str ) )
	    {
		if( findok( rreq, execfile, param ) ) return( -1 );
		    return( 0 );
	    }
	}
    }
    return( -1 );
}

int findok(char *execreq, char *exec, char **param)
{
    int rc = 0, i;
    long size = 0;
    char cmd[PATH_MAX+CHAR_MAX]="\0";

    strcpy( find->file, execreq );
    strcpy( find->path, REQEXEC );

    //    -  .

    //  NO_LIMIT = TRUE -   !
    if( ( limit->no_limit == FALSE )
	//     ,   
	//  .
#if defined(PGSQL) || defined(MY_SQL) || defined(MYDB)
	&& ( file_dayDB() >= limit->file_day ||
	file_weekDB() >= limit->file_week ||
	file_monthDB() >= limit->file_month ||
	NFILE >= limit->file_session )
#endif	/* PGSQL || MY_SQL || MYDB */
	)
    {
	strcpy( find->file, req->file ); // ???
#ifdef	DEBUG
	printf( "[%s] File: %s - Files limit is exhausted\n",
	    FTN_ADDR, find->file );
#endif	/* DEBUG */
	log( "File: %s - Files limit is exhausted", find->file );
	//   REP_FILE      .
	rep_file( "%s - %s", find->file, koi2alt( LIMIT_FILES ) );
	FIND = 0;	//    0.
	return( 0 );
    }

#ifdef	DEBUG
    printf( "path: %s\n", find->path );
#endif	/* DEBUG */
    //  ,      REQEXEC 
    //   execreq!!!
    //  cmd = exec + param
    i = 0;
    strcpy( cmd, exec );
    while( param[i] != NULL )
    {
	strcat( cmd, " " );
	strcat( cmd, param[i] );
	free( param[i++] ); //  .
    }
    param[0] = NULL;
    // TODO ---     ... ;(
    rc = execsh( cmd );
    log( "Exec \"%s\", rc = %d", cmd, rc );
#ifdef	DEBUG
    printf( "Exec \"%s\", rc = %d\n", cmd, rc );
#endif	/* DEBUG */
    //   ...  0 --- ,    
    // !
    if( strlen( execreq ) != 0 ) size = sizefile();
    else strcpy( find->file, req->file ); // ???
    if( size == 0 && rc != 0 ){ FIND = -1; return( -1 ); }

    //      .

    //  NO_LIMIT = TRUE -   !
    if( ( limit->no_limit == FALSE )
#if defined(PGSQL) || defined(MY_SQL) || defined(MYDB)
	&& ( size + size_dayDB() > limit->size_day ||
	size + size_weekDB() > limit->size_week ||
	size + size_monthDB() > limit->size_month ||
	size + SIZE > limit->size_session )
#endif	/* PGSQL || MY_SQL || MYDB */
	)
    {
#ifdef	DEBUG
	printf( "[%s] File: %s (%ld) - size limit is exhausted\n",
	    FTN_ADDR, find->file, size );
#endif	/* DEBUG */
	log( "File: %s (%d) - size limit is exhausted", find->file, size );
	//   REP_FILE      .
	rep_file( "%s (%db) - %s", find->file, size, koi2alt( LIMIT_SIZE ) );
	FIND = 0;	//    0.
	return( 0 );

    }

#if defined( PGSQL ) || defined( MY_SQL ) || defined(MYDB)
    if( insert_new_find() ) return( -1 );
#endif	/* PGSQL || MY_SQL || MYDB */
    return( 0 );
}
