#include <stdio.h>
#include <limits.h>
#include "includes.h"
#include "../version.h"

LIMIT_TYPE *limit;
GLOBAL_TYPE *gl;

char *read_command(FILE *in)
{
	int c, i;
	static char command[CHAR_MAX];

	if( in == NULL ) return( NULL );

	i = 0;
	while( ( c = getc( in ) ) != EOF )
	{
		if( c == '~' || c == '\n' || c == '\r' || i >= CHAR_MAX )
		{
			command[i] = 0;
			return( command );
		}
		//      .
		if( c == '\t' ) c = '\x20';
		command[i++] = c;
	}
	if( c == EOF ) return( NULL );	// end of file
	command[i] = 0;
	return( command );
}

int answer(char *file)
{
	FILE *in, *out;
	int c;
	char *command, str[CHAR_MAX];

	if( !REP_FILE ) return( 0 );
	if( !file ) return( 0 );

	if( ( in = fopen( file, "r" ) ) == NULL ) return( -1 );

	if( ( out = fopen( REP_FILE, "a" ) ) == NULL )
	{
		fclose( in );
		return( -1 );
	}

	//  .
	while( ( c = getc( in ) ) != EOF )
	{
		if( c == '~' )
		{
			command = read_command( in );
			if( command )
			{
				//  ,    ---
				//   .
				if( !strcasecmp( command, "address" ) )
				{
					fputs( FTN_ADDR, out );
				}
				else if( !strcasecmp( command, "speed" ) )
				{
					snprintf( str, sizeof(str)-1, "%d",
							SPEED );
					fputs( str, out );
				}
				else if( !strcasecmp( command, "system" ) )
				{
					switch( FTN_SYSTEM )
					{
					case PROTECT:
						fputs( "Protected", out );
	    					break;
					case UNPROTECT:
						fputs( "UnProtected", out );
	    					break;
					case LISTED:
						fputs( "Listed", out );
	    					break;
					case ALL:
						fputs( "Unlisted", out );
	    				break;
					}
				}
				else if( !strcasecmp( command, "ls_session" ) )
				{
#ifndef	WIN32
					snprintf( str, sizeof(str)-1, "%ld",
							limit->size_session );
#else
					sprintf( str, "%ld",
							limit->size_session );
#endif	/* WIN32 */
					fputs( str, out );
				}
				else if( !strcasecmp( command, "lf_session" ) )
				{
#ifndef	WIN32
					snprintf( str, sizeof(str)-1, "%ld",
							limit->file_session );
#else
					sprintf( str, "%ld",
							limit->file_session );
#endif	/* WIN32 */
					fputs( str, out );
				}
				else if( !strcasecmp( command, "ls_day" ) )
				{
#ifndef	WIN32
					snprintf( str, sizeof(str)-1, "%ld",
							limit->size_day );
#else
					sprintf( str, "%ld", limit->size_day );
#endif	/* WIN32 */
					fputs( str, out );
				}
				else if( !strcasecmp( command, "lf_day" ) )
				{
#ifndef	WIN32
					snprintf( str, sizeof(str)-1, "%ld",
							limit->file_day );
#else
					sprintf( str, "%ld", limit->file_day );

#endif	/* WIN32 */
					fputs( str, out );
				}
				else if( !strcasecmp( command, "ls_week" ) )
				{
#ifndef	WIN32
					snprintf( str, sizeof(str)-1, "%ld",
							limit->size_week );
#else
					sprintf( str, "%ld", limit->size_week );
#endif	/* WIN32 */
					fputs( str, out );
				}
				else if( !strcasecmp( command, "lf_week" ) )
				{
#ifndef	WIN32
					snprintf( str, sizeof(str)-1, "%ld",
							limit->file_week );
#else
					sprintf( str, "%ld", limit->file_week );
#endif	/* WIN32 */
					fputs( str, out );
				}
				else if( !strcasecmp( command, "ls_month" ) )
				{
#ifndef	WIN32
					snprintf( str, sizeof(str)-1, "%ld",
							limit->size_month );
#else
					sprintf( str, "%ld",
							limit->size_month );
#endif	/* WIN32 */
					fputs( str, out );
				}
				else if( !strcasecmp( command, "lf_month" ) )
				{
#ifndef	WIN32
					snprintf( str, sizeof(str)-1, "%ld",
							limit->file_month );
#else
					sprintf( str, "%ld",
							limit->file_month );
#endif	/* WIN32 */
					fputs( str, out );
				}
				else if( !strcasecmp( command, "lower_speed" ) )
				{
					snprintf( str, sizeof(str)-1, "%d",
							limit->lower_speed );
					fputs( str, out );
				}
				else if( !strcasecmp( command, "string" ) )
				{
					if( gl->string_2alt == TRUE )
					{
					 if( limit->string != NULL )
					  fputs( koi2alt( limit->string ),
							  out );
					}
					else if( limit->string != NULL )
					{
					  if( SRIF_FREQ )
					   fputs( limit->string, out );
					    else
					  if( !SRIF_FREQ )
					   fputs( koi2alt( limit->string ),
							   out );
					}
				}
				// end
				else if( !strcasecmp( command, "ts_session" ) )
				{
#ifndef	WIN32
					snprintf( str, sizeof(str)-1, "%ld",
							SIZE );
#else
					sprintf( str, "%ld", SIZE );
#endif	/* WIN32 */
					fputs( str, out );
				}
				else if( !strcasecmp( command, "tf_session" ) )
				{
					snprintf( str, sizeof(str)-1, "%d",
							NFILE );
					fputs( str, out );
				}
				else if( !strcasecmp( command, "ts_day" ) )
				{
#ifndef	WIN32
					snprintf( str, sizeof(str)-1, "%ld",
							size_dayDB() );
#else
					sprintf( str, "%ld", size_dayDB() );
#endif	/* WIN32 */
					fputs( str, out );
				}
				else if( !strcasecmp( command, "tf_day" ) )
				{
					snprintf( str, sizeof(str)-1, "%d",
							file_dayDB() );
					fputs( str, out );
				}
				else if( !strcasecmp( command, "ts_week" ) )
				{
#ifndef	WIN32
					snprintf( str, sizeof(str)-1, "%ld",
							size_weekDB() );
#else
					sprintf( str, "%ld", size_weekDB() );
#endif	/* WIN32 */
					fputs( str, out );
				}
				else if( !strcasecmp( command, "tf_week" ) )
				{
					snprintf( str, sizeof(str)-1, "%d",
							file_weekDB() );
					fputs( str, out );
				}
				else if( !strcasecmp( command, "ts_month" ) )
				{
#ifndef	WIN32
					snprintf( str, sizeof(str)-1, "%ld",
							size_monthDB() );
#else
					sprintf( str, "%ld", size_monthDB() );
#endif	/* WIN32 */
					fputs( str, out );
				}
				else if( !strcasecmp( command, "tf_month" ) )
				{
					snprintf( str, sizeof(str)-1, "%d",
							file_monthDB() );
					fputs( str, out );
				}
				else if( !strcasecmp( command, "s_total" ) )
				{
#ifndef	WIN32
					snprintf( str, sizeof(str)-1, "%ld",
							TotalSizeDB() );
#else
					sprintf( str, "%ld", TotalSizeDB() );
#endif	/* WIN32 */
					fputs( str, out );
				}
				else if( !strcasecmp( command, "f_total" ) )
				{
					snprintf( str, sizeof(str)-1, "%d",
							TotalFileDB() );
					fputs( str, out );
				}
				else if( !strcasecmp( command, "stat" ) )
				{
					snprintf( str, sizeof(str)-1, "%s",
							timer_stop() );
					fputs( str, out );
					log( "Session stat: %s sec.", str );
				}
				// other
				else if( !strcasecmp( command, "myaddr" ) )
				{
					if( gl->ftnaddr )
						fputs( gl->ftnaddr, out );

				}
				else if( !strcasecmp( command, "sysop" ) )
				{
					if( SYSOP ) fputs( SYSOP, out );
				}
				else if( !strcasecmp( command, "rsysop" ) )
				{
					if( RSYSOP ) fputs( RSYSOP, out );
				}
				else if( !strcasecmp( command, "tmafreq" ) )
				{
#ifndef	WIN32
					snprintf( str, sizeof(str)-1,
						"External freq processor"\
						" (v%d.%d.%d)" \
						" (C) Maxim Timofeyev,"\
						" 2:5030/763", VERSION_MAJOR,
						VERSION_MINOR, PATHLEVEL );
#else
					sprintf( str,
						"External freq processor"\
						" (v%d.%d.%d/WIN32)"\
						" (C) Maxim Timofeyev,"\
						" 2:5030/763", VERSION_MAJOR,
						VERSION_MINOR, PATHLEVEL );
#endif	/* WIN32 */
					fputs( str, out );
				}
				//   .
				else
				{
					//     .
					fputs( command, out );
				}
			}
		}
		else
		{
			if( c == '\r' ) continue;
			if( c == '\n' ) fputs( CRLF, out );
			else fputc( c, out );
		}
	}
	fclose( in );
	fclose( out );
	return( 0 );
}
