/***************************************************************************/
/*                                                                         */
/* parsecfg - a library for parsing a configuration file                   */
/* Copyright (C) 1999 Yuuki NINOMIYA, gm@smn.enjoy.ne.jp                   */
/*                                                                         */
/* This program is free software; you can redistribute it and/or modify    */
/* it under the terms of the GNU General Public License as published by    */
/* the Free Software Foundation; either version 2, or (at your option)     */
/* any later version.                                                      */
/*                                                                         */
/* This program is distributed in the hope that it will be useful,         */
/* but WITHOUT ANY WARRANTY; without even the implied warranty of          */
/* MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the           */
/* GNU General Public License for more details.                            */
/*                                                                         */
/* You should have received a copy of the GNU General Public License       */
/* along with this program; if not, write to the                           */
/* Free Software Foundation, Inc., 59 Temple Place - Suite 330,            */
/* Boston, MA 02111-1307, USA.                                             */
/*                                                                         */
/***************************************************************************/

#include <stdio.h>
#include "parsecfg.h"	/* include this header file when use parsecfg library */


/************************/
/*    for CFG_SIMPLE    */
/************************/

/* variables stored got value */

/* If there is no parameter in the configuration file,
   the value is not changed.
   However if linked list isn't set initial value,
   it must be initialized by NULL. */

int cfg_bool;
int cfg_int;
int cfg_int_not_change=489;
unsigned int cfg_uint;
long cfg_long;
unsigned long cfg_ulong;
char *cfg_str;	/* pointer to string (Memories stored real string is allocated dynamically.) */
cfgList *cfg_list=NULL;	/* pointer to linked list */


/* array of cfgStruct */
   
cfgStruct cfg[]={	/* this must be initialized */
	/* parameter	type		address of variable */
	{"BOOL"		,CFG_BOOL	,&cfg_bool },
	{"INT"		,CFG_INT        ,&cfg_int  },
	{"UINT"		,CFG_UINT       ,&cfg_uint },
	{"LONG"		,CFG_LONG       ,&cfg_long },
	{"ULONG"	,CFG_ULONG      ,&cfg_ulong},
	{"STR"		,CFG_STRING     ,&cfg_str  },
	{"LIST"		,CFG_STRING_LIST,&cfg_list },
	{"NoChange"	,CFG_INT        ,&cfg_int_not_change },
	{NULL ,CFG_END ,NULL}	/* no more parameters */
};



/************************/
/*     for CFG_INI      */
/************************/

/* variables stored got value */

/* If there is no parameter in the configuration file,
   the value is initialized 0 or NULL (boolean value is
   initialized -1(FALSE)). */

int *ini_bool;
int *ini_int;
unsigned int *ini_uint;
long *ini_long;
unsigned long *ini_ulong;
char **ini_str;
cfgList **ini_list;


/* array of cfgStruct */

cfgStruct cfgini[]={
	/* parameter	type		address of variable */
	{"BOOL"		,CFG_BOOL	,&ini_bool },
	{"INT"		,CFG_INT        ,&ini_int  },
	{"UINT"		,CFG_UINT       ,&ini_uint },
	{"LONG"		,CFG_LONG       ,&ini_long },
	{"ULONG"	,CFG_ULONG      ,&ini_ulong},
	{"STR"		,CFG_STRING     ,&ini_str  },
	{"LIST"		,CFG_STRING_LIST,&ini_list },
	{NULL ,CFG_END ,NULL}	/* no more parameters */
};



int main(void)
{
	cfgList *l;
	int max,i;

	cfgParse("sample.cfg",cfg,CFG_SIMPLE);

	printf("BOOL  : %s\n",cfg_bool ? "TRUE" : "FALSE");	/* 1 is "TRUE", 0 is "FALSE" */
	printf("INT   : %d\n",cfg_int);
	printf("NoChange : %d\n",cfg_int_not_change);
	printf("UINT  : %u\n",cfg_uint);
	printf("LONG  : %ld\n",cfg_long);
	printf("ULONG : %lu\n",cfg_ulong);
	printf("STR   : %s\n",cfg_str);

	l=cfg_list;
	if(l!=NULL){
		for(;;){
			printf("LIST  : %s\n",l->str);
			if(l->next==NULL){
				break;
			}
			l=l->next;
		}
	}

	cfgDump("sample.cfg.dump",cfg,CFG_SIMPLE,0);

	max=cfgParse("sample.ini",cfgini,CFG_INI);
	printf("\n\n\nmax=%d\n",max);
	for(i=0;i<max;i++){
		printf("\n[%s]\n",cfgSectionNumberToName(i));

		printf("BOOL  : %s\n",ini_bool[i] ? "TRUE" : "FALSE");	/* 1 is "TRUE", 0 is "FALSE" */
		printf("INT   : %d\n",ini_int[i]);
		printf("UINT  : %u\n",ini_uint[i]);
		printf("LONG  : %ld\n",ini_long[i]);
		printf("ULONG : %lu\n",ini_ulong[i]);
		printf("STR   : %s\n",ini_str[i]);

		if(ini_list[i]==NULL){
			continue;
		}
		for(l=ini_list[i];l!=NULL;l=l->next){
			printf("LIST  : %s\n",l->str);
		}
	}
	printf("\nSection name [LiNuX] is No.%d\n",cfgSectionNameToNumber("LiNuX"));
	printf("Section name [fsf GNU] is No.%d\n",cfgSectionNameToNumber("fsf GNU"));

	cfgDump("sample.ini.dump",cfgini,CFG_INI,max);

	return(0);
}

