//  $Revision: 1.3 $

#include <stdio.h>
#include <string.h>
#include <stdlib.h>
#include <sys/stat.h>
#include <dirent.h>
#include "includes.h"

#ifdef	WIN32
#ifndef	MYDB
#define	MYDB
#endif	/* MYDB */
#undef	PGSQL
#undef	MY_SQL
#undef	DESC
#endif	/* WIN32 */

#ifdef	PGSQL
#include <pgsql/libpq-fe.h>
PGconn	   *conn;
PGresult   *res;
#endif	/* PGSQL */
#ifdef	MY_SQL
#include <mysql.h>
MYSQL mysql,*sock;
MYSQL_ROW row;
MYSQL_RES *res;
#endif	/* MY_SQL */

char *FILELIST;
long SIZE=0;
char AREA_PATH[PATH_MAX]="\0";

#if defined(PGSQL) || defined(MY_SQL)
SQL_TYPE *sql;
#endif	/* PGSQL || MY_SQL */

GLOBAL_TYPE *gl;

// :
//     path     ---
//   .    .
//    ,    ...
void fileecho(FILE *f, char *path)
{
	FILE *ff;
	char descpath[PATH_MAX];
	char area[CHAR_MAX]="<no name>\0";

#ifdef	DEBUG
	printf( "\n-----\nAREA_PATH: \"%s\"\n", AREA_PATH );
	printf( "path: \"%s\"\n", path );
#endif	/* DEBUG */

	//    ...
	if( !strcmp( AREA_PATH, path ) ) return;
	//  .

	// 1.  AREA_PATH   ...
	strcpy( AREA_PATH, path );
	// 2.     ...
#ifdef	DESC
	snprintf( descpath, sizeof(descpath)-1, "%s/.desc/.desc", path );
#ifdef	DEBUG
	printf( "descpath: \"%s\"\n", descpath );
#endif	/* DEBUG */
	// 3.     .desc/.desc -.
	if( ( ff = fopen( descpath, "r" ) ) != NULL )
	{
		// 3.2.   ---      
		//   (  )
		if( !fseek( ff, 2, SEEK_SET ) )
		{
			fgets( area, sizeof(area)-1, ff );
			skip_crlf( area );
		}
		// 3.3.    ...
		fclose( ff );
	}
#endif	/* DESC */
	// 4.  .
	fprintf( f, "+---+------------------------------------------+--------------+-------------+%s", CRLF );
	// 4.         
	//  --- 61   .
	area[61] = 0;
	//       
	// koi8-r -> cp866
	fprintf( f, "| File Area:  %-61s |%s", koi2alt( area ), CRLF );
#ifdef	DEBUG
	printf( "FileArea: \"%s\"\n-----\n", area );
#endif	/* DEBUG */
	fprintf( f, "+---+------------------------------------------+--------------+-------------+%s", CRLF );
	// 5. .
}

#ifdef	PGSQL
void exit_nicely(PGconn *conn)
{
//    PQclear( res ); //   ...    ... ;(
    PQfinish( conn );
}

int init_pgsql()
{
    char   *pgoptions, *pgtty;

    pgoptions = NULL;		/* special options to start up the backend
				 * server */
    pgtty = NULL;		/* debugging tty for the backend server */

    /* make a connection to the database */
    conn = PQsetdb( sql->host, sql->port, pgoptions, pgtty, sql->dbName );

    /* check to see that the backend connection was successfully made */
    if( PQstatus( conn ) == CONNECTION_BAD )
    {
	printf( "Connection to database '%s' failed.\n", sql->dbName );
	printf( "%s", PQerrorMessage( conn ) );

	exit_nicely( conn );

	return( -1 );
    }

    return( 0 );
}
#endif	/* PGSQL */

#ifdef	MY_SQL
void exit_nicely(MYSQL *sock)
{
    if( res != NULL ) mysql_free_result( res );
    mysql_close( sock );
}

int init_mysql()
{
    mysql_init( &mysql );
    if( !( sock = mysql_real_connect( &mysql, sql->host,
	sql->user, sql->passwd, sql->dbName, atoi( sql->port ), NULL, 0 ) ) )
    {
	fprintf( stderr, "Couldn't connect to engine! \"%s\"\n",
			mysql_error( &mysql ) );
#ifdef	DEBUG
	printf( "init_mysql() - connect to database failed...\n" );
#endif	/* DEBUG */

	exit_nicely( sock );

	return( -1 );
    }

#ifdef	DEBUG
    printf( "init_mysql() - connect Ok.\n" );
#endif	/* DEBUG */

    return( 0 );
}
#endif	/* MY_SQL */

int readSQL()
{
#if !defined(MY_SQL) && !defined(MYDB)
    int nTuples;
#endif	/* !MY_SQL && !MYDB */
    int i = 0;
    long size;
#ifndef	MYDB
    char str[CHAR_MAX];
#endif	/* MYDB */
    char ffile[PATH_MAX];
    char *alias=NULL, *file=NULL, *path=NULL, system, *passwd=NULL, *DATE;
    FILE *f;
#ifdef	MY_SQL
    unsigned int num_fields = 0;
    int total = 0;
    char tmp[CHAR_MAX];
#endif	/* MY_SQL */
#ifdef	MYDB
    int total = 0;
#endif	/* MYDB */

    if( ( f = fopen( FILELIST, "a" ) ) == NULL )
    {
	fprintf( stderr, "FILELIST \"%s\" file can't be opened!\n",
	 FILELIST );
#ifdef	PGSQL
	exit_nicely( conn );
#endif	/* PGSQL */

#ifdef	MY_SQL
	exit_nicely( sock );
#endif	/* MY_SQL */
	return( -1 );
    }

#ifndef	DONOT_STDOUT
    fprintf( stdout, "Opening FILELIST...\n" );
#endif	/* DONOT_STDOUT */

#if defined(PGSQL) || defined(MY_SQL)
    //       'path'
    snprintf( str, sizeof(str)-1,
		    "SELECT DISTINCT * FROM %s ORDER BY path ASC;",
		    sql->table_freq );
#endif	/* PGSQL || MY_SQL */

#ifdef	PGSQL
    res = PQexec( conn, str );
    if( PQresultStatus( res ) != PGRES_TUPLES_OK )
    {
        fprintf( stderr, "SQL!> SELECT * FROM command failed!\n" );
	printf( "%s", PQerrorMessage( conn ) );

	exit_nicely( conn );

	return( -1 );
    }

    nTuples = PQntuples( res );
#endif	/* PGSQL */

#ifdef	MY_SQL
    if( mysql_query( sock, str ) )
    {
	fprintf( stderr, "Query failed (%s)\n", mysql_error( sock ) );
	return( -1 );
    }

    if( !( res = mysql_store_result( sock ) ) )
    {
	fprintf( stderr, "Couldn't get result from query failed! \"%s\"\n",
			mysql_error( sock ) );
	exit_nicely( sock );
	return( -1 );
    }
#endif	/* MY_SQL */

    fprintf( f, "+---------------------------------------------------------------------------+%s", CRLF );
    fprintf( f, "| sys - 'a' - all, 'l' - listed, 'p' - protected system, '*' - password     |%s", CRLF );
    fprintf( f, "+----------------------------------------------+--------------+-------------+%s", CRLF );
    fprintf( f, "|sys|                   files                  |     size     |     date    |%s", CRLF );
    fprintf( f, "+---+------------------------------------------+--------------+-------------+%s", CRLF );

#ifdef	PGSQL
    for( i = 0; i < nTuples; i++ )
    {
	alias = PQgetvalue( res, i, 0 );
	file = PQgetvalue( res, i, 1 );
	path = PQgetvalue( res, i, 2 );
	snprintf( str, sizeof(str)-1, "%s", PQgetvalue( res, i, 3 ) );
	system = str[0];
	passwd = PQgetvalue( res, i, 4 );

	//   passwd   ---   system   '*'
	if( strlen( passwd ) != 0 ) system = '*';

	ffile[0]=0;
	snprintf( ffile, sizeof(ffile)-1, "%s/%s", path, file );

	//    ,       alias !=  file
	if( !strcmp( file, alias ) )
	{
	    //
	    size = sizefile( ffile );
	    SIZE += size;

	    // :
	    //     path     ---
	    //   .    .
	    //    ,    ...
	    fileecho( f, path );

	    DATE = datefile( ffile );
	    if( DATE != NULL )
		fprintf( f, "| %c | %-40s | %-12s | %s |%s",
			system, file, strsize( size ), DATE, CRLF );
	}
	else
	    //  , ..      !
	    nTuples--;
    }
#endif	/* PGSQL */

#ifdef	MY_SQL
    while( ( row = mysql_fetch_row( res ) ) )
    {
	total++;
	//     - .
	if( alias ){ free( alias ); alias = NULL; }
	if( file ){ free( file ); file = NULL; }
	if( path ){ free( path ); path = NULL; }
	system = 0;
	if( passwd ){ free( passwd ); passwd = NULL; }

	num_fields = mysql_num_fields( res );
	for( i = 0; i < num_fields; i++ )
	{
	    switch( i )
	    {
		case 0:
		    alias = strdup( row[i] );
		    break;
		case 1:
		    file = strdup( row[i] );
		    break;
		case 2:
		    path = strdup( row[i] );
		    break;
		case 3:
		    snprintf( tmp, sizeof(tmp)-1, "%s", row[i] );
		    system = tmp[0];
		    break;
		case 4:
		    passwd = strdup( row[i] );
		    break;
	    }
	}

	//   passwd   ---   system   '*'
	if( strlen( passwd ) != 0 ) system = '*';

	ffile[0]=0;
	snprintf( ffile, sizeof(ffile)-1, "%s/%s", path, file );

	//    ,       alias !=  file
	if( !strcmp( file, alias ) )
	{
	    //
	    size = sizefile( ffile );
	    SIZE += size;

	    // :
	    //     path     ---
	    //   .    .
	    //    ,    ...
	    fileecho( f, path );

	    DATE = datefile( ffile );
	    if( DATE != NULL )
		fprintf( f, "| %c | %-40s | %-12s | %s |%s",
			system, file, strsize( size ), DATE, CRLF );
	}
	else
	    //  , ..      !
	    total--;
    }
#endif	/* MY_SQL */

#ifndef	MYDB
    fprintf( f, "+---+------------------------------------------+--------------+-------------+%s", CRLF );
#ifdef	MY_SQL
#ifndef	DONOT_STDOUT
    fprintf( stdout, "Total notes: %d\n", total );
#endif	/* DONOT_STDOUT */
    fprintf( f, "| Total files: %11d                                                  |%s", total, CRLF );
#endif	/* MY_SQL */
#ifdef	PGSQL
#ifndef	DONOT_STDOUT
    fprintf( stdout, "Total notes: %d\n", nTuples );
#endif	/* DONOT_STDOUT */
    fprintf( f, "+---------------------------------------------------------------------------+%s", CRLF );
    fprintf( f, "| Total files: %11d                                                  |%s", nTuples, CRLF );
#endif	/* PGSQL */
    fprintf( f, "| Total size: %10ld b                       %-26s |%s",
	SIZE, strsize( SIZE ), CRLF );
    fprintf( f, "+---------------------------------------------------------------------------+%s", CRLF );
#endif	/* MYDB */

#ifdef	MYDB
    if( alias ){ free( alias ); alias = NULL; }
    if( file ){ free( file ); file = NULL; }
    if( path ){ free( path ); path = NULL; }
    system = 0;
    if( passwd ){ free( passwd ); passwd = NULL; }

    while( 1 )
    {
	//    -1 --- .
	if( read_freq_idx( i++ ) ) break;
	total++;
	alias = strdup( FREQ_TABLE.alias );
	file = strdup( FREQ_TABLE.file );
	path =strdup( FREQ_TABLE.path );
	system = FREQ_TABLE.system;
	passwd = strdup( FREQ_TABLE.passwd );
	//   passwd   ---   system   '*'
	if( strlen( passwd ) != 0 ) system = '*';

#ifndef	WIN32
	snprintf( ffile, sizeof(ffile)-1, "%s/%s", path, file );
#else
	snprintf( ffile, sizeof(ffile)-1, "%s\\%s", path, file );
#endif	/* WIN32 */

	//    ,       alias !=  file
	if( !strcmp( file, alias ) )
	{
	    //
	    size = sizefile( ffile );
	    SIZE += size;

	    // :
	    //     path     ---
	    //   .    .
	    //    ,    ...
	    fileecho( f, path );

	    DATE = datefile( ffile );
	    if( DATE != NULL )
		fprintf( f, "| %c | %-40s | %-12s | %s |%s",
			system, file, strsize( size ), DATE, CRLF );
	}
	else
	    //  , ..      !
	    total--;
    }

    fprintf( f, "+---+------------------------------------------+--------------+-------------+%s", CRLF );
#ifndef	DONOT_STDOUT
    fprintf( stdout, "Total notes: %d\n", total );
#endif	/* DONOT_STDOUT */
    fprintf( f, "| Total files: %11d                                                  |%s", total, CRLF );
    fprintf( f, "| Total size: %10ld b                       %-26s |%s",
	SIZE, strsize( SIZE ), CRLF );
    fprintf( f, "+---------------------------------------------------------------------------+%s", CRLF );
#endif	/* MYDB */

    fclose( f );

#ifdef	PGSQL
    exit_nicely( conn );
#endif	/* PGSQL */

#ifdef	MY_SQL
    exit_nicely( sock );
#endif	/* MY_SQL */

    return( 0 );
}

int main(int argc, char *argv[])
{
    int rc;

    if( argc <= 1 )
    {
#ifndef	WIN32
	fprintf( stderr, "Use %s </path/listfile.txt>\n", argv[0] );
#else
	fprintf( stderr, "Use %s <C:\\PATH\\LISTFILE.TXT>\n", argv[0] );
#endif	/* WIN32 */
	return( -1 );
    }

    //  .
#if defined(PGSQL) || defined(MY_SQL)
    sql = calloc( 1, sizeof( struct sql_type ) );
#endif	/* PGSQL || MY_SQL */
    gl = calloc( 1, sizeof( struct global_type ) );

    //  .
    readcfg( 0 );

    //   CRLF   '\r\n'  Unix  '\n'  Win32
#ifndef	WIN32
    strcpy( CRLF, "\r\n" );
#else
    strcpy( CRLF, "\n" );
#endif	/* WIN32 */

    copyascfile_koi82alt( gl->head, argv[1] );

    FILELIST = argv[1];

#ifdef	PGSQL
    if( init_pgsql() )
    {
	    //  .
	    free( sql );
	    free( gl );
	    return( -1 );
    }
#endif	/* PGSQL */

#ifdef	MY_SQL
    if( init_mysql() )
    {
	    //  .
	    free( sql );
	    free( gl );
	    return( -1 );
    }
#endif	/* MY_SQL */

    //  SQL
    rc = readSQL();

    //  ...
#if defined(PGSQL) || defined(MY_SQL)
    free( sql );
#endif	/* PGSQL || MY_SQL */
    free( gl );

    return( rc );
}
