#include <stdio.h>
#include <sys/stat.h>
#include <unistd.h>
#include <errno.h>
#include <time.h>
#include "includes.h"

long sizefile(char *file)
{
    long size = 0;
    struct stat	statv;

#ifdef	DEBUG
    printf( "file: \"%s\"\n", file );
#endif	/* DEBUG */

    if( stat( file, &statv ) )
    {
	if( errno != ENOENT )
	    fprintf( stderr, "File \"%s\" - unknown error!", file );
	size = 0;
	return( 0 );
    }
    size = statv.st_size;

    return( size );
}

char *datefile(char *file)
{
    static char s[CHAR_MAX];
    struct stat	statv;
    struct tm *local_tm;

    if( stat( file, &statv ) )
    {
	if( errno != ENOENT )
	    fprintf( stderr, "File \"%s\" - unknown error!", file );
	return( NULL );
    }

    local_tm = localtime( &statv.st_mtime );

    strftime( s, sizeof(s)-1, "%d-%b-%Y", local_tm );

    return( s );
}
