#include <stdio.h>
#include <string.h>
#include <stdlib.h>
#include <sys/stat.h>
#include <dirent.h>
#include <ctype.h>
#include <limits.h>
#include "includes.h"

#ifdef	WIN32
#ifndef	MYDB
#define	MYDB
#endif	/* MYDB */
#undef	PGSQL
#undef	MY_SQL
#undef	DESC
#endif	/* WIN32 */

#ifdef	PGSQL
#include <pgsql/libpq-fe.h>
PGconn	   *conn;
PGresult   *res;
#endif	/* PGSQL */
#ifdef	MY_SQL
#include <mysql.h>
MYSQL mysql,*sock;
MYSQL_ROW row;
MYSQL_RES *res;
#endif	/* MY_SQL */

#if defined(PGSQL) || defined(MY_SQL)
SQL_TYPE *sql;
#endif	/* PGSQL || MYSQL */

GLOBAL_TYPE *gl;

struct FREQFILE {
	char alias[CHAR_MAX];
	char file[CHAR_MAX];
	char path[PATH_MAX];
	char system;
	char passwd[CHAR_MAX];
} freq;

#ifdef	PGSQL
void exit_nicely(PGconn *conn)
{
//    PQclear( res ); //   ...    ... ;(
    PQfinish( conn );
}

int init_pgsql()
{
    char   *pgoptions, *pgtty;

    pgoptions = NULL;		/* special options to start up the backend
				 * server */
    pgtty = NULL;		/* debugging tty for the backend server */

    /* make a connection to the database */
    conn = PQsetdb( sql->host, sql->port, pgoptions, pgtty, sql->dbName );

    /* check to see that the backend connection was successfully made */
    if( PQstatus( conn ) == CONNECTION_BAD )
    {
	fprintf( stderr, "Connection to database '%s' failed.\n", sql->dbName );
	fprintf( stderr, "%s", PQerrorMessage( conn ) );

	exit_nicely( conn );

	return( -1 );
    }

    return( 0 );
}
#endif	/* PGSQL */

#ifdef	MY_SQL
void exit_nicely(MYSQL *sock)
{
    if( res != NULL ) mysql_free_result( res );
    mysql_close( sock );
}

int init_mysql()
{
    mysql_init( &mysql );
    if( !( sock = mysql_real_connect( &mysql, sql->host,
	sql->user, sql->passwd, sql->dbName, atoi( sql->port ), NULL, 0 ) ) )
    {
	fprintf( stderr, "Couldn't connect to engine! \"%s\"",
			mysql_error( &mysql ) );
#ifdef	DEBUG
	printf( "init_mysql() - connect to database failed...\n" );
#endif	/* DEBUG */

	exit_nicely( sock );

	return( -1 );
    }

#ifdef	DEBUG
    printf( "init_mysql() - connect Ok.\n" );
#endif	/* DEBUG */

    return( 0 );
}
#endif	/* MY_SQL */

void insert();
#ifdef	DELETE
void sqldelete();
#endif /* DELETE */

int main(int argc, char *argv[])
{
    //  .
#if defined(PGSQL) || defined(MY_SQL)
	sql = calloc( 1, sizeof( struct sql_type ) );
#endif	/* PGSQL || MYSQL */
	gl = calloc( 1, sizeof( struct global_type ) );

	//  .
	readcfg( 0 );

#ifdef	PGSQL
	if( init_pgsql() ) return( -1 );
#endif	/* PGSQL */

#ifdef	MY_SQL
	if( init_mysql() ) return( -1 );
#endif	/* MY_SQL */

#ifdef	DELETE
#ifndef	DONOT_STDOUT
	fprintf( stdout, "DELETE old base from freq table...\n" );
#endif	/* DONOT_STDOUT*/
#ifndef	DEBUG
	sqldelete();
#endif /* DEBUG */

#endif /* DELETE */

	if( readopenfile( gl->paths ) )
		return( -1 );

#ifdef	PGSQL
	exit_nicely( conn );
#endif	/* PGSQL */

#ifdef	MY_SQL
	exit_nicely( sock );
#endif	/* MY_SQL */

	return( 0 );
}

int scandirectory(char *directory)
{
	FILE *f = NULL;
	DIR *d = NULL;
	struct dirent *dp;
	struct stat statv;
#ifdef	DESC
	char desc[PATH_MAX];
#endif	/* DESC */

#ifndef	DONOT_STDOUT
	fprintf( stdout, "Scaning directory: \"%s\"\n", directory );
#endif	/* DONOT_STDOUT */

	if( ( d = opendir( directory ) ) == NULL )
	{
		fprintf( stderr, "Directory \"%s\" cannot be opened!\n",
				directory );
		return( -1 );
	}

#ifndef	DONOT_STDOUT
	fprintf( stdout, "DIRECTORY: %s\n", directory );
#endif	/* DONOT_STDOUT */

	//   freq.system - 'a' (all systems).
	freq.system = 'a';

#ifdef	DESC
	//         ...
	snprintf( desc, sizeof(desc)-1, "%s/.desc/.desc", directory );

	if( ( f = fopen( desc, "r" ) ) == NULL )
	{
#ifndef	DONOT_STDOUT
		fprintf( stdout, "DESC \"%s\" file don't exist - freq enable for protected systems only!\n", desc );
#endif	/* DONOT_STDOUT */
		freq.system = 'p';
	}
	else
	{
		//     .
		freq.system = tolower( fgetc( f ) );
		fclose( f );	//  .
	}

	//     'a'  'l',
	//    - 'p' (protected systems)
	if( freq.system != 'a' && freq.system != 'l' ) freq.system = 'p';
#endif	/* DESC */

	while( ( dp = readdir( d ) ) )
	{
#ifdef	WIN32
		snprintf( freq.file, sizeof(freq.file)-1, "%s\\%s",
			directory, dp->d_name );
#else
		snprintf( freq.file, sizeof(freq.file)-1, "%s/%s",
			directory, dp->d_name );
#endif	/* WIN32 */
		if( stat( freq.file, &statv ) )
		{
			perror( "stat" );
			return( -1 );
		}

		switch( statv.st_mode&S_IFMT )
		{
			case S_IFDIR:
				break;
#ifndef	WIN32
			case S_IFLNK:
				break;
#endif	/* WIN32 */
			case S_IFREG:
			if( strcmp( dp->d_name, "." ) ||
					strcmp( dp->d_name, ".." ) ||
				dp->d_name[0] != '.' )
			{
#ifndef	DONOT_STDOUT
				fprintf( stdout, "FILE: %s -", dp->d_name );
#endif	/* DONOT_STDOUT */
				strcpy( freq.path, directory );
				strcpy( freq.file, dp->d_name );
#ifndef	DEBUG
				//     -DDEBUG -
				//    .
				insert();
#else
#ifndef	DONOT_STDOUT
				fprintf( stdout, " insert, freq's for " );
				switch( freq.system )
				{
					case 'a':
						fprintf( stdout, "all" );
						break;
					case 'l':
						fprintf( stdout, "listed" );
						break;
					case 'p':
						fprintf( stdout, "protected" );
						break;
				}
				fprintf( stdout, " systems\n" );
#endif	/* DONOT_STDOUT */
#endif
			}
				break;
			default:
				break;
		}
	}

	closedir( d );

	return( 0 );
}

#ifndef	DEBUG

#if defined(PGSQL) || defined(MY_SQL)
void SQLinsert(char *str)
{
#ifdef	PGSQL
	res = PQexec( conn, str );
	if( atoi( PQcmdTuples( res ) ) <= 0 )
	{
        	fprintf( stderr, "INSERT INTO command failed!\n" );
		fprintf( stderr, "%s", PQerrorMessage( conn ) );
//		PQclear( res );
		exit_nicely( conn );

		exit( -1 );
	}
	PQclear( res );
#endif	/* PGSQL */

#ifdef	MY_SQL
	if( mysql_query( sock, str ) )
	{
        	fprintf( stderr, "INSERT INTO command failed!\n" );
		fprintf( stderr, "Query failed (%s)\n", mysql_error( sock ) );
		return;
	}
#endif	/* MY_SQL */
}
#endif	/* PGSQL || MY_SQL */

void insert()
{
#ifndef	MYDB
	char str[10240];
#endif	/* MYDB */
	char file[PATH_MAX];
	char *filename;
	FILE *f;
#ifndef	DELETE
	int num = 0;
#endif	/* DELETE */

	if( !( filename = validname( freq.file ) ) )
	{
		fprintf( stderr, "Error in filename \"%s\"\n", freq.file );
		return;
	}

#ifndef	DELETE

	//      .
	snprintf( str, sizeof(str)-1, "SELECT * FROM freq WHERE " \
		"file='%s' AND path='%s'", filename, freq.path );

#ifdef	PGSQL
	res = PQexec( conn, str );

	if( PQresultStatus( res ) != PGRES_TUPLES_OK )
	{
		fprintf( stderr, "SELECT * FROM command failed!\n" );
		fprintf( stderr, "%s", PQerrorMessage( conn ) );
//		PQclear( res );
		exit_nicely( conn );
	}

	num = PQntuples( res );
#endif	/* PGSQL */

#ifdef	MY_SQL
	if( mysql_query( sock, str ) )
	{
		fprintf( stderr, "Query failed (%s)\n", mysql_error( sock ) );
		return;
	}

	if( !( res = mysql_store_result( sock ) ) )
	{
		fprintf( stderr,
			"Couldn't get result from query failed! \"%s\"\n",
			mysql_error( sock ) );
		exit_nicely( sock );
		return;
	}

	row = mysql_fetch_row( res );
//	snprintf( str, sizeof(str)-1, "%s", row[0] );
//	num = atoi( str );
#endif	/* MY_SQL */

#ifndef	MY_SQL
	if( num > 0 )
	{
#ifndef	DONOT_STDOUT
		fprintf( stdout, " do not insert (%d copies)!\n", num );
#endif	/* DONOT_STDOUT */
		return;
	}
#endif	/* MY_SQL */

#endif /* DELETE */

	//    .
#ifdef	DESC
	snprintf( file, sizeof(file)-1, "%s/.desc/%s.pwd",
		freq.path, freq.file );

	//  .
	if( ( f = fopen( file, "r" ) ) == NULL )
	{
		//  !
		strcpy( freq.passwd, "\0" );
	}
	else
	{
		fgets( freq.passwd, CHAR_MAX, f );
		skip_crlf( freq.passwd );
		fclose( f );	//  .
	}
#else
	//  !
	strcpy( freq.passwd, "\0" );
#endif	/* DESC */

#ifdef	DESC
	//  alias  .
	snprintf( file, sizeof(file)-1, "%s/.desc/%s.alias",
		freq.path, freq.file );

	//  .
	if( ( f = fopen( file, "r" ) ) == NULL )
	{
		//  !
		strcpy( freq.alias, freq.file );
	}
	else
	{
		fgets( freq.alias, CHAR_MAX, f );
		skip_crlf( freq.alias );
		fclose( f );	//  .
	}
#else
	strcpy( freq.alias, freq.file );
#endif	/* DESC */

	//  ,  .
	if( strcmp( freq.alias, freq.file ) )
	{
#ifndef	MYDB
		snprintf( str, sizeof(str)-1,
				"INSERT INTO freq VALUES('%s','%s'," \
				"'%s','%c','%s');",
//				freq.alias, freq.file, freq.path, freq.system,
				freq.alias, filename, freq.path, freq.system,
				freq.passwd );
		SQLinsert( str );
#else
		strcpy( FREQ_TABLE.alias, freq.alias );
		strcpy( FREQ_TABLE.file, freq.file );
		strcpy( FREQ_TABLE.path, freq.path );
		FREQ_TABLE.system = freq.system;
		strcpy( FREQ_TABLE.passwd, freq.passwd );
		//   idx.
		write_freq_idx();
#endif	/* MYDB */
	}

	//    . (  ,     
	//   ).
#ifndef	MYDB
	snprintf( str, sizeof(str)-1, "INSERT INTO freq VALUES('%s','%s'," \
			"'%s','%c','%s');",
			filename, filename, freq.path, freq.system,
			freq.passwd );
	SQLinsert( str );
#else
	strcpy( FREQ_TABLE.alias, freq.file );
	strcpy( FREQ_TABLE.file, freq.file );
	strcpy( FREQ_TABLE.path, freq.path );
	FREQ_TABLE.system = freq.system;
	strcpy( FREQ_TABLE.passwd, freq.passwd );
	//   idx.
	write_freq_idx();
#endif	/* MYDB */

#ifndef	DONOT_STDOUT
	switch( freq.system )
	{
		case 'a':
			fprintf( stdout, "insert, freq's for all system\n" );
			break;
		case 'l':
			fprintf( stdout,
				"insert, freq's for listed systems\n" );
			break;
		case 'p':
			fprintf( stdout,
				"insert, fres's for protected systems\n" );
			break;
	}
#endif	/* DONOT_STDOUT */
}

#ifdef	DELETE
void sqldelete()
{
#ifdef MYDB
	remove( INDEX_FREQ );	//  .
#else
	char str[10240];

	snprintf( str, sizeof(str)-1, "DELETE FROM freq;" );

#ifdef	PGSQL
	res = PQexec( conn, str );
	if( atoi( PQcmdTuples( res ) ) < 0 )
	{
 		fprintf( stderr, "DELETE command failed!\n" );
		fprintf( stderr, "%s", PQerrorMessage( conn ) );
//		PQclear( res );
		exit_nicely( conn );

		exit( -1 );
	}
//	PQclear( res );
#endif	/* PGSQL */

#ifdef	MY_SQL
	if( mysql_query( sock, str ) )
	{
		fprintf( stderr, "Query failed (%s)\n", mysql_error( sock ) );
		return;
	}
#endif	/* MY_SQL */
#endif	/* MYDB */
}
#endif	/* DELETE */

#endif /* DEBUG */
