// --------------------------------------------------------------------
//        P a s s w d . c p p
//                                                                     
//        Fido messages tracker                            
//        Password support
// --------------------------------------------------------------------
//        Copyright (c) 1998,99 by Fyodor Ustinov                         
//                              FIDONet 2:5020/79                      
//                                                                     
//        All rights reserved.                                         
// --------------------------------------------------------------------
#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <ctype.h>
#include "constant.hpp"
#include "help.hpp"
#include "utils.hpp"
#include "vars.hpp"
#include "fidoaddr.h"
#include "scandir.hpp"
#include "ufmtypes.h"

// --------------------------------------------------------------------

class tPasswd {
public:
   FA _Addr;
   char _Passwd[9];
   tPasswd() { _Addr.Clean(); memset(_Passwd,0,8); };
   ~tPasswd() { return; };
};

IndBiList<tPasswd> Passwd;
// --------------------------------------------------------------------

void AddPasswd(FA &Addr, char *P) {
tPasswd *a;

   a = new tPasswd;
   a->_Addr = Addr;
   strncpy(a->_Passwd,P,8);
   Passwd.AddToEnd(a);
}

char *GetPasswd(FA const &Addr) {
IndBiList<tPasswd>::ElemPtr tmt;

   for (tmt = Passwd.GetFirst(); tmt != NULL; tmt++) {
      if (tmt->_Addr == Addr) {
         return tmt->_Passwd;
      }
   }   
   return NULL;
}

int SetPasswd(FA &f, char *tmt) {
char Pwd[9];

   if (strlen(tmt) == 0) {
      yyerror("Missed parameter: Password.");
      return (-1);
   }

   if (strlen(tmt) > 8) {
      yyerror("Password should be no more 8 characters.");
      return (-1);
   }

   if (!f.Valid()) {
      yyerror("Invalid addres.");
      return (-1);
   }
   strcpy(Pwd,tmt);
   nls_strupr(Pwd);
   AddPasswd(f,Pwd);
   return(0);
}

void DestroyPasswd(void) {
   Passwd.Clear();
}

// ---------------------------- END --------------------------------------
