#ifndef _PKTBASE_HPP_
#define _PKTBASE_HPP_

#include <time.h>
#include "a_list.hpp"
#include "utils.hpp"
#include "fidoaddr.h"
#include "msg.hpp"
#include "msgbase.hpp"
#include "ufmtypes.h"


class PKTBASE: public MSGBASE {
   FA           FMask;
   char         *DirName;
   char         *PktName;
   char         *MsgMask;
   unsigned int MsgNum;
   unsigned int MaxMsgNum;
   int          fNoCheckPwd;
   FILE         *fh;
   DIR          *dp;
   int          fForWrite;
   int          fCreated;
   
   int _Close(void);
   int _Open(void);
   void AddToMask(unsigned int Num);
   int CopyHeader(FILE *tf);
   int CopyTail(FILE *tf);
   int CopyMessages(FILE *tf);
   int CopyOneMessage(FILE *tf);
public:
   int WriteOneMsg(unsigned int Num, cMSG &m);   
   PKTBASE();
   ~PKTBASE();
   void Print(void);
   int Set(char *c, int BaseType);
   void Clear(void);
   int Next(void);
   int Rewind(void);
   int DeleteMsg(void);
   int ReadMsg(cMSG &m);
   int WriteMsg(cMSG &m);
   int WriteNewMsg(cMSG &m);
   char *ReadToMem(void);
   int WriteFromMem(char *Buff);
   //  { return FALSE; };
   char *MessageName(void);
   char *BaseName(void);
   int  Renumber(void);
   int CheckOut(void);
   int CheckIn(void) { return TRUE; };
   int Open(void) { return TRUE; };
   int Close(void) { return _Close(); };
};

#endif

