#ifndef _NODELIST_HPP_
#define _NODELIST_HPP_

#include <time.h>
#include "fidoaddr.h"

#define DefaultIndex   "ftrack.ndl"            // default index file
#define NdlSign        0xfeda2054U             // Signature of nodelist index

extern char *NodelistPath;

typedef struct {
   char Name[512];
   time_t  Time;
   dword   StartZone;
} NodeListElem;

typedef struct _Nch {
   dword         Number;
   struct _Nch  *Sub;
} Nch;


class NodeLists {
   NodeListElem *NList;
   int          Lists;
   char         *IndexName;
   Nch          *Index;
   int          StartZone;
private:
   int CompileNeed(void);
   int Compile(void);
   int LoadOneIndex(FILE *fh, Nch *&Ind);
   Nch *Srch(Nch *Addr, unsigned int Number);
public:
   NodeLists();
   ~NodeLists();
   int AddNodelist(char *tmt, int TempZone);
   void IndexFile(char *Name);
   void Print(void);
   int Load(void);
   unsigned int ExistInNodelist(FA const &f);
   int InSubHubs(FA const &Addr, FA const &Mask);
   int Enabled(void) { return (Lists != 0); };
   char *Names(char *Buf);
};

int SetMaxNodelistAge(int tmt);
int SetNodelist(char *tmt, int TempZone);



#endif

