/*--------------------------------------------------------------------*/
/*       L o g . h p p                                                */
/*                                                                    */
/*       Definitions file for class "log"                             */
/*--------------------------------------------------------------------*/
/*       Copyright (c) 1999 by Fyodor Ustinov                         */
/*                          FIDONet 2:5020/79                         */
/*                                                                    */
/*       All rights reserved.                                         */
/*--------------------------------------------------------------------*/
#ifndef _LOG_HPP_
#define _LOG_HPP_

#include <stdio.h>
#include "ufmtypes.h"

#define EOL '\n'

class LogStream {
   FILE *fh;
   uint _LogLevel;
   uint cLogLevel;
   int  NewLine;
private:
   void ShowLine(const char *format, ...)
#ifdef __GNUC__
   __attribute__ ((format (printf, 2, 3)))
#endif
   ;

public:
    LogStream ();
    ~LogStream ();
    int Open(char *FName);
    int Opened(void) { return (fh != NULL); };
    int Close(void);
    void LogLevel(uint);
    LogStream &Level(uint);
    LogStream &operator << (const char *p);
    LogStream &operator << (char p);
    LogStream & operator << (int i);    
    LogStream & operator << (unsigned int i);    
    LogStream & operator << (word i);    // word/sword is always a 16 bit int,
    LogStream & operator << (sword i);   // smapi takes care for this, and
    LogStream & operator << (dword i);   // dword/sdword is always 32 bit, even
    LogStream & operator << (sdword i);  // on a 64 bit host
};

char *Date(void);

#endif





