/*:ts=8*/
/*****************************************************************************
 * FIDOGATE --- Gateway UNIX Mail/News <-> FTN NetMail/EchoMail
 *
 * $Id: confval.c,v 1.1.2.2 2002/11/27 01:05:15 dyff Exp $
 *
 * Active group
 *
 *****************************************************************************
 * Copyright (C) 2001-2002
 * 
 *    Dmitry Fedotov            FIDO:      2:5030/1229
 *				Internet:  dyff@fidogate.spb.ru
 *
 * This file is part of FIDOGATE.
 *
 * FIDOGATE is free software; you can redistribute it and/or modify it
 * under the terms of the GNU General Public License as published by the
 * Free Software Foundation; either version 2, or (at your option) any
 * later version.
 *
 * FIDOGATE is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with FIDOGATE; see the file COPYING.  If not, write to the Free
 * Software Foundation, 675 Mass Ave, Cambridge, MA 02139, USA.
 *****************************************************************************/

#include "fidogate.h"
#include "getopt.h"

#define PROGRAM 	"confval"
#define VERSION 	"$Revision: 1.1.2.2 $"
#define CONFIG		DEFAULT_CONFIG_MAIN


void usage(void)
{
    fprintf(stderr, "FIDOGATE %s  %s %s\n\n",
	    version_global(), PROGRAM, version_local(VERSION) );
    
    fprintf(stderr, "usage:   %s [-options] \n\n", PROGRAM);
    fprintf(stderr, "\
	  -p --param VARIABLE          this help\n\
          -v --verbose                 more verbose\n\
	  -h --help                    this help\n\
          -c --config name             read config file (\"\" = none)\n");
    
    exit(0);
}


int main(int argc, char **argv)
{
    int c;
    char *p;
    char *c_flag = NULL;
    char *p_flag = NULL;

    int option_index;
    static struct option long_options[] =
    {
	{ "verbose",      0, 0, 'v'},	/* More verbose */
	{ "help",         0, 0, 'h'},	/* Help */
	{ "config",       1, 0, 'c'},	/* Config file */
	{ "param",        1, 0, 'c'},
	{ 0,              0, 0, 0  }
    };

    while ((c = getopt_long(argc, argv, "hvp:c:",
			    long_options, &option_index     )) != EOF)
	switch (c) {
	case 'h':
	    usage();
	    break;
	case 'c':
	    c_flag = optarg;
	    break;
	case 'v':
	    verbose++;
	    break;
	case 'p':
	    p_flag = optarg;
	    break;
	default:
	    usage();
	    exit(EX_USAGE);
	    break;
	}

    debug(0, "%s", c_flag);
    cf_initialize();
    cf_read_config_file(c_flag ? c_flag : CONFIG);

    if( (p = cf_get_string(p_flag, TRUE)) )
    {
	fprintf(stderr, "fidogate_%s=\"%s\"; export %s\n", p_flag, p, p_flag);
    }
    else
	debug(4, "variable %s does not specifed\n", p_flag);
    
    exit_free();
    exit(0);
}
