/*:ts=8*/
/*****************************************************************************
 * FIDOGATE --- Gateway UNIX Mail/News <-> FTN NetMail/EchoMail
 *
 * $Id: ftninpost.c,v 1.1.2.5 2003/03/01 23:49:45 dyff Exp $
 *
 * Processing inbound packets
 *
 *****************************************************************************
 * Copyright (C) 2001
 * 
 *    Dmitry Fedotov            FIDO:      2:5030/1229
 *				Internet:  dyff@fidogate.spb.ru
 *
 * This file is part of FIDOGATE.
 *
 * FIDOGATE is free software; you can redistribute it and/or modify it
 * under the terms of the GNU General Public License as published by the
 * Free Software Foundation; either version 2, or (at your option) any
 * later version.
 *
 * FIDOGATE is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with FIDOGATE; see the file COPYING.  If not, write to the Free
 * Software Foundation, 675 Mass Ave, Cambridge, MA 02139, USA.
 *****************************************************************************/

#include "fidogate.h"
#include "getopt.h"


#define PROGRAM 	"ftninpost"
#define VERSION 	"$Revision: 1.1.2.5 $"
#define CONFIG		DEFAULT_CONFIG_MAIN

typedef struct split_t {
    char *id;
    int  part;
    int  parts;
    char *fname;
    struct split_t *next;
} split;

/*
 * Prototypes
 */
void	short_usage		(void);
void	usage			(void);


int	do_dir			(char *, int);

char	ftnin_sendmail[MAXPATH] = {0};
char   *ftnin_rnews;
split  *split_first = NULL;
split  *split_last;

/*
 * Usage messages
 */
void short_usage(void)
{
    fprintf(stderr, "usage: %s [-options]\n", PROGRAM);
    fprintf(stderr, "       %s --help  for more information\n", PROGRAM);
}


void usage(void)
{
    fprintf(stderr, "FIDOGATE %s  %s %s\n\n",
	    version_global(), PROGRAM, version_local(VERSION) );
    
    fprintf(stderr, "usage:   %s [-options]\n\n", PROGRAM);
    fprintf(stderr, "\
options: -v --verbose                 more verbose\n\
	 -h --help                    this help\n\
         -c --config name             read config file (\"\" = none)\n");
    
    exit(0);
}

/*
int unsplit_mail_count(char *fname) {
    FILE *fp;
    char line[100];
    int found = FALSE;
    char *s;
    int idlen;
    split *spl;
    
    debug(1, "Processing %s", fname);
    
    fp = fopen(fname, "r");
    if(!fp) {
	log("can't open %s", fname);
        return ERROR;
    }
    while((fgets(line, sizeof(line), fp)))
	if(!strncasecmp(line, "X-SPLIT:", 8)) {
	    found = TRUE;
	    break;
	}
    if(!found)
        return OK;

    for(idlen=0, s=&line[9]; s; s++, idlen++) {
	if(isdigit(*s) && isdigit(*(s+1)) && *(s+2) == '/' &&
	   isdigit(*(s+3)) && isdigit(*(s+4))) {

	      spl = (split *)xmalloc(sizeof(split));
	      if(!split_first)
	         split_first = spl;
	      else
	         split_last->next = spl;
	      spl->next = NULL;

	      s[idlen-1]='\0';
	      spl->id = strsave(line);
	      s[2] = '\0';
	      spl->parts = atoi(s+3);
	      s[5] = '\0';
	      spl->part = atoi(s);
	      spl->fname = strsave(fname);
	      break;
	   }
    }
    debug(8,"ID: %s %d/%d", spl->id, spl->part, spl->parts);
    
    fclose(fp);

    return OK;
}

int unsplit_mail() {

    split *spl;

    debug(1, "Processing split mails\n");
    
    for(spl = split_first; spl; spl=spl->next) {
	split *splt;
	split *sfirst;
	int count = 0;
	for(splt = split_first; splt; splt=splt->next) {
	    if(!strcmp(spl->id, splt->id)) {
	       if(spl->part == 1)
	          sfirst = spl;
	       count++;
	    }
 	}
	// fixme - processing from first split //
	if(spl->parts == count) {
	    FILE *fp, *usp;
            char path[MAXPATH];
            int linesline=0;
            int lines;
            int flag=0;
	    
	    debug(3, "Message %s complete, recombining", spl->id);
	    
	    fp = fopen(sfirst->fname, "r");
	    if(!fp) {
	       log("can't open %s", sfirst->fname);
	       continue;
	    }
            BUF_COPY2(path, sfirst->fname, ".unsplit");
	    usp = fopen(path, "w");
            if(!usp) {
		log("can't open %s for writing", path);
                continue;
            }
            while(fgets(buffer, BUFSIZ, fp)) {
           	if(*buffer == '\n')
                    flag++;
                if(flag == 0) {
           	    if(strnicmp(buffer, "Lines: ", 7)) {
                        lines = atoi(&buffer[7]);
               	        flag++;
                    }
	            else
                        linesline++;
                } else if(flag == 1) {
                    if(strnicmp(buffer, "X-SPLIT:", 8))
                        flag++;
                }
            }
	} else {
	    log("Message %s incomplete", spl->id);
	}
    }

    return 0;
}
*/
int do_dir(char *cdir, int mode)
{
    DIR *dp;
    struct dirent *dir;
    char buf[MAXPATH+MAXINETADDR];

    if( ! ( dp = opendir(cdir) ) )
    {
	debug(7,"can't open directory %s", cdir);
	return ERROR;
    }
    while((dir = readdir(dp)))
    {
	if(wildmatch(dir->d_name, "*.rfc", TRUE))
	{
	    char rfc_file[MAXPATH];
	    FILE *fp;
	    char *p, *s;
	    int ret;

	    BUF_COPY3(rfc_file, cdir, "/", dir->d_name);
	    debug(8, "Processing %s mode=%d", rfc_file, mode);
/*
	    if(mode == 0)
	    {
	        unsplit_mail_count(rfc_file);
		unsplit_mail();
	    }

	    else
*/
	    if(mode == 1 || mode == 2)
	    {
                if(mode == 1) {
		    fp = fopen(rfc_file, "r");
		    if(!fp)
		        continue;

		    p = fgets(buffer, sizeof(buffer), fp);
                    fclose(fp);
		    if(!p)
		        continue;
		    if(strncmp(p, "From ", 5)) {
		        debug(9, "WARNING: \"From\" string not found");
                    } else {
		        s = xstrtok(p+5?p+5:"", " \t");
		        BUF_COPY(buf, ftnin_sendmail);
		        if( (p = strstr(buf, " -f%s")) )
			    BUF_COPY(p, p+5);
		        BUF_APPEND2(buf, " -f", s);
                    }
                    p = buf;
		} else {
                    p = ftnin_rnews;
		}
		debug(8, "exec: %s", p);
		freopen(rfc_file, R_MODE, stdin);
		ret = system(p);
		fclose(stdin);
		if(ret != 0)
		{
		    log("$WARNING: %s returned non-zero status", p);
		    return ERROR;
		} else {
		    unlink(rfc_file);
		}
	    }
	}
    }
    dir_close();

    return OK;
}


/***** main() ****************************************************************/

int main(int argc, char **argv)
{
    int c;
    char *c_flag=NULL;
    char buf[MAXPATH] = {0};
    char *p;

    int option_index;
    static struct option long_options[] =
    {
	{ "verbose",      0, 0, 'v'},	/* More verbose */
	{ "help",         0, 0, 'h'},	/* Help */
	{ "config",       1, 0, 'c'},	/* Config file */
	{ 0,              0, 0, 0  }
    };

    log_program(PROGRAM);
    
    /* Init configuration */
    cf_initialize();


    while ((c = getopt_long(argc, argv, "vhc:",
			    long_options, &option_index     )) != EOF)
	switch (c) {
	/***** Common options *****/
	case 'v':
	    verbose++;
	    break;
	case 'h':
	    usage();
	    exit(0);
	    break;
	case 'c':
	    c_flag = optarg;
	    break;
	default:
	    short_usage();
	    exit(EX_USAGE);
	    break;
	}

    /*
     * Read config file
     */
    cf_read_config_file(c_flag ? c_flag : CONFIG);

    cf_debug();

    passwd_init();

    ftnin_rnews = NULL;

    if( (p = cf_get_string("FTNInSendmail", TRUE)) )
    {
	debug(8, "config: FTNInSendmail %s", p);
	BUF_COPY(ftnin_sendmail, p);
    }
    else
	debug(9, "WARNING: FTNInSendmail not defined in %s", c_flag ? c_flag : CONFIG);

    if( (p = cf_get_string("FTNInRnews", TRUE)) )
    {
	debug(8, "config: FTNInRnews %s", p);
	ftnin_rnews = p;
    }
    else
	debug(9, "WARNING: FTNInRnews not defined in %s", c_flag ? c_flag : CONFIG);

    if( (p = cf_get_string("FTNInRecombine", TRUE)) )
    {
	debug(8, "config: FTNInRecombine %s", p);
	BUF_EXPAND(buf, p);
    }
    else
	debug(9, "WARNING: FTNInRecombine not defined in %s", c_flag ? c_flag : CONFIG);

    if(*buf)
	run_system(buf);

    BUF_EXPAND(buf, cf_p_outrfc_mail());
//    do_dir(buf, 0);
    do_dir(buf, 1);
    BUF_EXPAND(buf, cf_p_outrfc_news());
    do_dir(buf, 2);
/*
    unsplit_mail("test");    
*/
    exit_free();
    exit(EX_OK);
}
