{&CDecl+}
library dsp_more;

uses
     VPUtils,

     Objects,
     Strings,

     Windows,

     Dos,

     Wizard;

type
      PSamples = ^TSamples;
      TSamples = array[0..0] of SmallInt;

      PModule = ^TModule;
      TModule = record
       Description: PChar;
       Parent: HWND;
       Instance: HINST;
       Config: procedure(Module: PModule);
       Init: function(Module: PModule): Integer;
       Modify: function(Module: PModule; Samples: PSamples; Count, bps, Channels, Rate: Integer): Integer;
       Quit: procedure(Module: PModule);
       UserData: Pointer;
      end;

      PHeader = ^THeader;
      THeader = record
       Version: Integer;
       Description: PChar;
       GetModule: function(Module: Integer): PModule;
      end;

procedure Config(Module: PModule); forward;
function Init(Module: PModule): Integer; forward;
function Modify(Module: PModule; Samples: PSamples; Count, bps, Channels, Rate: Integer): Integer; forward;
procedure Quit(Module: PModule); forward;
function GetModule(Module: Integer): PModule; forward;

const
 HeaderVersion          = $20;

 Modifier: TModule =
       (Description     : 'more DSPs ;)';
        Parent          : 0;
        Instance        : 0;
        Config          : Config;
        Init            : Init;
        Modify          : Modify;
        Quit            : Quit);

 Header: THeader =
       (Version         : HeaderVersion;
        Description     : 'more DSPs ;)';
        GetModule       : GetModule
       );

type
 PPlugin = ^TPlugin;
 TPlugin = object(TObject)
  Handle: HINST;
  Header: PHeader;
  Module: PModule;

  constructor Init(const AFName: String; const AModule: Integer; const AOurModule: PModule);
  destructor Done; virtual;
 end;

constructor TPlugin.Init(const AFName: String; const AModule: Integer; const AOurModule: PModule);
 var
  FName: array[0..255] of Char;
  GetHeader: function: PHeader;
 begin
  inherited Init;

  StrPCopy(FName, AFName);

  Handle:=LoadLibrary(FName);

  if Handle < 32 then
   begin
    StrPCopy(FName, 'Unable to load ' + AFName + ', rc=#' + Int2Str(Handle));

    MessageBox(0, FName, 'more DSPs ;)', mb_ok or mb_iconerror);

    Handle:=0;

    Fail;
   end;

  @GetHeader:=GetProcAddress(Handle, 'winampDSPGetHeader2');

  if @GetHeader = nil then
   begin
    StrPCopy(FName, 'Failed to load ' + AFName + ': couldn''t locate winampDSPGetHeader2 function');

    MessageBox(0, FName, 'more DSPs ;)', mb_ok or mb_iconerror);

    FreeLibrary(Handle);

    Fail;
   end;

  Header:=GetHeader;

  Module:=Header^.GetModule(AModule);

  if Module = nil then
   begin
    StrPCopy(FName, 'Failed to load ' + AFName + ': couldn''t locate module N' + Int2Str(AModule));

    MessageBox(0, FName, 'more DSPs ;)', mb_ok or mb_iconerror);

    FreeLibrary(Handle);

    Fail;
   end;

  Module^.Parent:=AOurModule^.Parent;
  Module^.Instance:=Handle;

  if Module^.Init(Module) <> 0 then
   begin
    FreeLibrary(Handle);

    Fail;
   end;
 end;

destructor TPlugin.Done;
 begin
  if Handle <> 0 then
   FreeLibrary(Handle);

  inherited Done;
 end;

const
 Plugins: PCollection = nil;

function Init(Module: PModule): Integer;
 var
  D: array[0..255] of Char;
  S: String;
  F: Text;
  P: PPlugin;
  I: Integer;
 begin
  Plugins:=New(PCollection, Init($10, $10));

  if IOResult <> 0 then;

  Assign(F, AddBackSlash(JustPathName(ParamStr(0))) + 'dsp_more.ini');

  Reset(F);

  if IOResult <> 0 then
   begin
    StrPCopy(D, 'Unable to open ' + AddBackSlash(JustPathName(ParamStr(0))) + 'dsp_more.ini');

    MessageBox(0, D, 'more DSPs ;)', mb_ok or mb_iconerror);

    Dispose(Plugins, Done);

    Result:=1;

    Exit;
   end;

  while not Eof(F) do
   begin
    ReadLn(F, S);

    if S = '' then
     Continue;

    Str2Longint(ExtractWord(2, S, [' ']), I);

    P:=New(PPlugin, Init(ExtractWord(1, S, [' ']), I, Module));

    if P <> nil then
     Plugins^.Insert(P);
   end;

  Close(F);

  if IOResult <> 0 then;

  Result:=0;
 end;

procedure Config(Module: PModule);
 var
  S: array[0..16383] of Char;
 {&Cdecl-}
 procedure AppendStuff(Plugin: PPlugin); far;
 {&Cdecl+}
  begin
   StrCat(S, Plugin^.Header^.Description);

   StrCat(S, ': ');

   StrCat(S, Plugin^.Module^.Description);

   StrCat(S, #13);
  end;
 begin
  StrPCopy(S, 'more DSPs ;)'#13'(q) by sk // [rAN], 2000.'#13'mailto:skank@mail.ru'#13'http://www.irnet.ru/sk'#13#13);

  if Plugins^.Count = 0 then
   StrCat(S, 'No plugins in queue.')
  else
   begin
    StrCat(S, 'Now working (in order of sound processing):'#13#13);

    Plugins^.ForEach(@AppendStuff);
   end;

  MessageBox(0, S, 'more DSPs ;)', mb_ok or mb_iconinformation);
 end;

function Modify(Module: PModule; Samples: PSamples; Count, bps, Channels, Rate: Integer): Integer;
 {&CDecl-}
 procedure ModifyModule(Plugin: PPlugin); far;
 {&CDecl+}
  begin
   Count:=Plugin^.Module^.Modify(Plugin^.Module, Samples, Count, bps, Channels, Rate);
  end;
 begin
  Plugins^.ForEach(@ModifyModule);

  Modify:=Count;
 end;

procedure Quit(Module: PModule);
 {&CDecl-}
 procedure QuitModule(const Plugin: PPlugin); far;
 {&Cdecl+}
  begin
   Plugin^.Module^.Quit(Plugin^.Module);
  end;
 begin
  Plugins^.ForEach(@QuitModule);

  Dispose(Plugins, Done);
 end;

function GetModule(Module: Integer): PModule;
 begin
  case Module of
   0: Result:=@Modifier;
  else
   Result:=nil;
  end;
 end;

function winampDSPGetHeader2: PHeader; cdecl;
 begin
  Result:=@Header;
 end;

exports
 winampDSPGetHeader2;

begin
end.
