#pragma once

class CBaseException
{
public:
	CBaseException(const string& aMsg) { msg = aMsg; }
	virtual ~CBaseException() {}

	const string& getMessage() const { return msg; }

protected:
	string	msg;
};


class CIOException : public CBaseException
{
public:
	CIOException(const string& aMsg) : CBaseException(aMsg) {}
};


class CInvalidFormatException : public CBaseException
{
public:
	CInvalidFormatException(const string& aMsg) : CBaseException(aMsg) {}
};


class CIllegalArgumentException : public CBaseException
{
public:
	CIllegalArgumentException(const string& aMsg) : CBaseException(aMsg) {}
};


class CWinAPIException : public CBaseException
{
public:
	CWinAPIException(const string& aMsg);

	const string& getLastErrorMessage() const { return lastErrorMsg; }

protected:
	string	lastErrorMsg;
};
