// Zoppa.cpp : Defines the entry point for the console application.
//

#include "stdafx.h"
#include "exceptions.h"
#include "TimeControl.h"
#include "OutboundReader.h"
#include "Log.h"

const MAJOR_VERSION_NUMBER = 1;
const MINOR_VERSION_NUMBER = 3;

void printUsageInfo() {
	cout << "Zoppa v" << MAJOR_VERSION_NUMBER << "." << MINOR_VERSION_NUMBER
		 << " (c) Alexander Zenovkin, 2:5023/19\n"
		 << "           (c) Andrey Kuprishov, 2:5023/27\n"
		 << "Usage:\n"
	     << "  -time hh:mm-hh:mm <outbound path> <temp path>\n"
		 << "  -save <outbound path> <temp path>\n"
		 << "  -restore <outbound path> <temp path>\n";
}


void printWinAPIException(CWinAPIException& ex) {
	cout << "[!] Critical error occured:\n"
		 << "app message = " << ex.getMessage().c_str() << "\n"
		 << "sys message = " << ex.getLastErrorMessage().c_str() << "\n";
}


int main(int argc, char* argv[])
{
	try {

		if (argc == 1) {
			printUsageInfo();
			return 0;
		}

		bool	toTemp = false;
		bool	go     = false;

		if (strcmp( argv[1], "-time" ) == 0) {
			// time should be specified
			if (argc == 5) {
				CTimeControl	timeControl( argv[2] );
				toTemp = timeControl.isNow();
				go     = true;
			}
		} else if (strcmp( argv[1], "-save" ) == 0) {
			if (argc == 4) {
				toTemp = true;
				go     = true;
			}
		} else if (strcmp( argv[1], "-restore" ) == 0) {
			if (argc == 4) {
				toTemp = false;
				go     = true;
			}
		}
		
		if (go) {
			COutboundReader	reader( argv[argc-2], argv[argc-1], toTemp );
		} else {
			printUsageInfo();
		}

	} catch (CWinAPIException& e1) {
		printWinAPIException( e1 );
		return 2;
	} catch (CBaseException& e2) {
		CLog::newLine() << "exception occured\n";
		CLog::newLine() << e2.getMessage() << "\n";
		return 1;
	}

	return 0;
}
