#include "StdAfx.h"
#include "timecontrol.h"

CTimeControl::CTimeControl(const string& timeFormat)
{
	// we wait string in format hh:mm-hh:mm
	int	offset = 0;
	int	startHour, startMinute, endHour, endMinute;

	if (timeFormat.size() != 11 ||
		!parse2Digits( timeFormat, 0, startHour ) ||
		startHour > 23 ||
		timeFormat[2] != ':' ||
		!parse2Digits( timeFormat, 3, startMinute ) ||
		startMinute > 59 ||
		timeFormat[5] != '-' ||
		!parse2Digits( timeFormat, 6, endHour ) ||
		endHour > 23 ||
		timeFormat[8] != ':' ||
		!parse2Digits( timeFormat, 9, endMinute ) ||
		endMinute > 59)
	{
		throw CInvalidFormatException( string("invalid time format: ") + timeFormat );
	}

	startTime = startHour*60 + startMinute;
	endTime   = endHour*60 + endMinute;
}

CTimeControl::~CTimeControl(void)
{
}


bool CTimeControl::isNow() const {
	SYSTEMTIME	localTime;
	::GetLocalTime( &localTime );

	int	curTime = localTime.wHour*60 + localTime.wMinute;

	if (startTime < endTime) {
		// we have a single interval
		return (curTime >= startTime) && (curTime < endTime);
	} else {
		// we have two intervals:
		// startTime-00:00 and 00:00-endTime
		return (curTime >= startTime) || (curTime < endTime);
	}
}


bool CTimeControl::parse2Digits(const string& format, int offset, int& num) const {
	if ((offset+1) >= format.size()) {
		return false;
	}

	char	c;

	c = format[offset++];
	if (!isdigit(c)) {
		return false;
	}

	num = c - '0';

	c = format[offset++];
	if (!isdigit(c)) {
		return false;
	}

	num = num*10 + (c - '0');

	return true;
}
