#pragma once

#include "exceptions.h"

/**
 * Reads normal (not temporary) outbound.
 */
class COutboundReader
{
public:
	COutboundReader(const string& anOutboundPath, const string& aTempPath, bool toTemp)
		throw (CIllegalArgumentException);
	virtual ~COutboundReader();

protected:
	string	outboundPath;
	string	tempPath;

	bool	sameDrive;

	void save();
	void checkTic(const string& path, const string& ticFileName);

	void restore();

	string getFixedPath(const string& path) const;

	void createPath(const string& path) const throw (CIOException);

	void makeDir(const char* dir) const throw (CIOException);

	void moveFile(const string& path, const string& name, bool toTemp) const throw (CIOException);
	void moveFileToTemp(const string& path, const string& name) const throw (CIOException) {
		moveFile( path, name, true );
	}
	void moveFileToOutbound(const string& path, const string& name) const throw (CIOException) {
		moveFile( path, name, false );
	}
};
