#pragma once

#include "exceptions.h"

class CLog
{
public:

	CLog& datetime() throw (CWinAPIException);

	CLog& operator <<(const char* msg);
	CLog& operator <<(const string& msg);
	CLog& operator <<(const char symbol);

	static CLog& getInstance() throw(CWinAPIException) {
		static CLog	log;
		return log;
	}

	static CLog& newLine() throw (CWinAPIException);

	static CLog& sameLine() throw (CWinAPIException) {
		return getInstance();
	}

protected:
	TCHAR	dateFormat[128];
	TCHAR	timeFormat[128];

	CLog(void) throw (CBaseException);
	~CLog(void);

	void formatTime(char* buffer) throw (CWinAPIException);
};
