#include "StdAfx.h"
#include "log.h"

CLog::CLog(void) throw (CWinAPIException)
{
	// prepare date format
	TCHAR	sepBuffer[64];
	if (::GetLocaleInfo( LOCALE_USER_DEFAULT, LOCALE_SDATE, sepBuffer, 64 ) == 0) {
		throw CWinAPIException( "failed to get date separator information for the user default locale" );
	}

	LPCTSTR	dateFormats[] = {
		TEXT("MM%sdd%syy"),
		TEXT("dd%sMM%syy"),
		TEXT("yy%sMM%sdd")
	};

	if (::GetLocaleInfo( LOCALE_USER_DEFAULT, LOCALE_IDATE, dateFormat, 2 ) == 0) {
		throw CWinAPIException( "failed to get short date format for the user default locale" );
	}

	int	index = dateFormat[0] - TEXT('0');
	if (index < 0 || index > 2)
		index = 0;
	wsprintf( dateFormat, dateFormats[index], sepBuffer, sepBuffer, sepBuffer );

	// prepare time format
	lstrcpy( timeFormat, TEXT(" HH:mm:ss") );
}

CLog::~CLog(void)
{
}

CLog& CLog::datetime() throw (CWinAPIException) {
	char	timeBuffer[128];
	formatTime( timeBuffer );

	cout << '[' << timeBuffer << "] ";

	return (*this);
}

CLog& CLog::operator <<(const char* msg) {
	cout << msg;

	return (*this);
}


CLog& CLog::operator <<(const string& msg) {
	cout << msg.c_str();

	return (*this);
}


CLog& CLog::operator <<(const char symbol) {
	cout << symbol;

	return (*this);
}


void CLog::formatTime(char* buffer) throw (CWinAPIException) {
	SYSTEMTIME	timeData;

	::GetLocalTime( &timeData );

	TCHAR	dateBuffer[128];
	if (::GetDateFormat( LOCALE_USER_DEFAULT, 0, &timeData, dateFormat, dateBuffer, 128 ) == 0) {
		throw CWinAPIException( "failed to get date format for user default locale" );
	}

	TCHAR	timeBuffer[128];
	if (::GetTimeFormat( LOCALE_USER_DEFAULT, 0, &timeData, timeFormat, timeBuffer, 128 ) == 0) {
		throw CWinAPIException( "failed to get time format for user default locale" );
	}

	lstrcpy( buffer, dateBuffer );
	lstrcat( buffer, timeBuffer );
}


CLog& CLog::newLine() throw (CWinAPIException) {
	return getInstance().datetime();
}
